/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.gson.Gson;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerStartEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BrokerAccountManagerStrategy
extends BrokerBaseStrategy {
    private static final String TAG = BrokerAccountManagerStrategy.class.getSimpleName();
    private static final String DATA_CACHE_RECORD = "com.microsoft.workaccount.cache.record";

    @Override
    @WorkerThread
    Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters parameters) throws ClientException {
        String methodName = ":getBrokerAuthorizationIntent";
        Logger.verbose((String)(TAG + ":getBrokerAuthorizationIntent"), (String)"Get the broker authorization intent from Account Manager.");
        return this.getBrokerAuthorizationIntentFromAccountManager(parameters);
    }

    @SuppressLint(value={"MissingPermission"})
    private Intent getBrokerAuthorizationIntentFromAccountManager(@NonNull AcquireTokenOperationParameters parameters) throws ClientException {
        Intent intent;
        String methodName = ":getBrokerAuthorizationIntentFromAccountManager";
        Telemetry.emit((BaseEvent)new BrokerStartEvent().putAction(":getBrokerAuthorizationIntentFromAccountManager"));
        try {
            MsalBrokerRequestAdapter msalBrokerRequestAdapter = new MsalBrokerRequestAdapter();
            Bundle requestBundle = new Bundle();
            BrokerRequest brokerRequest = msalBrokerRequestAdapter.brokerRequestFromAcquireTokenParameters(parameters);
            requestBundle.putInt("caller.info.uid", Binder.getCallingUid());
            requestBundle.putString("broker_request_v2", new Gson().toJson((Object)brokerRequest, BrokerRequest.class));
            AccountManager accountManager = AccountManager.get((Context)parameters.getAppContext());
            AccountManagerFuture result = accountManager.addAccount("com.microsoft.workaccount", "adal.authtoken.type", null, requestBundle, null, null, this.getPreferredHandler());
            Bundle bundleResult = (Bundle)result.getResult();
            intent = (Intent)bundleResult.getParcelable("intent");
            intent.putExtra("caller.info.uid", Binder.getCallingUid());
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":getBrokerAuthorizationIntentFromAccountManager").isSuccessful(true));
        }
        catch (OperationCanceledException e) {
            Logger.error((String)(TAG + ":getBrokerAuthorizationIntentFromAccountManager"), (String)"Broker request cancelled", (String)"Exception thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":getBrokerAuthorizationIntentFromAccountManager").isSuccessful(false).putErrorCode("Broker request cancelled").putErrorDescription("OperationCanceledException thrown when talking to account manager. The broker request cancelled."));
            throw new ClientException("Broker request cancelled", "OperationCanceledException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
        }
        catch (AuthenticatorException e) {
            Logger.error((String)(TAG + ":getBrokerAuthorizationIntentFromAccountManager"), (String)"Broker request cancelled", (String)"AuthenticatorException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":getBrokerAuthorizationIntentFromAccountManager").isSuccessful(false).putErrorCode("Broker request cancelled").putErrorDescription("AuthenticatorException thrown when talking to account manager. The broker request cancelled."));
            throw new ClientException("Broker request cancelled", "AuthenticatorException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
        }
        catch (IOException e) {
            Logger.error((String)(TAG + ":getBrokerAuthorizationIntentFromAccountManager"), (String)"Broker request cancelled", (String)"IOException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":getBrokerAuthorizationIntentFromAccountManager").isSuccessful(false).putErrorCode("Broker request cancelled").putErrorDescription("IOException thrown when talking to account manager. The broker request cancelled."));
            throw new ClientException("Broker request cancelled", "IOException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
        }
        return intent;
    }

    @Override
    @WorkerThread
    @SuppressLint(value={"MissingPermission"})
    AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters parameters) throws BaseException {
        String methodName = ":acquireTokenSilentWithAccountManager";
        Bundle bundleResult = null;
        if (parameters.getAccount() != null) {
            try {
                Bundle requestBundle = this.getSilentBrokerRequestBundle(parameters);
                AccountManager accountManager = AccountManager.get((Context)parameters.getAppContext());
                AccountManagerFuture result = accountManager.getAuthToken(this.getTargetAccount(parameters.getAppContext(), parameters.getAccount()), "adal.authtoken.type", requestBundle, false, null, this.getPreferredHandler());
                Logger.verbose((String)(TAG + ":acquireTokenSilentWithAccountManager"), (String)"Received result from broker");
                bundleResult = (Bundle)result.getResult();
            }
            catch (OperationCanceledException e) {
                Logger.error((String)(TAG + ":acquireTokenSilentWithAccountManager"), (String)"Broker request cancelled", (String)"Exception thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
                throw new ClientException("Broker request cancelled", "OperationCanceledException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            }
            catch (AuthenticatorException e) {
                Logger.error((String)(TAG + ":acquireTokenSilentWithAccountManager"), (String)"Broker request cancelled", (String)"AuthenticatorException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
                throw new ClientException("Broker request cancelled", "AuthenticatorException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            }
            catch (IOException e) {
                Logger.error((String)(TAG + ":acquireTokenSilentWithAccountManager"), (String)"Broker request cancelled", (String)"IOException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
                throw new ClientException("Broker request cancelled", "IOException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            }
        }
        return BrokerAccountManagerStrategy.getAcquireTokenResult(bundleResult);
    }

    @Override
    @WorkerThread
    @SuppressLint(value={"MissingPermission"})
    protected List<ICacheRecord> getBrokerAccounts(@NonNull OperationParameters parameters) throws OperationCanceledException, IOException, AuthenticatorException, ClientException {
        String methodName = ":getBrokerAccountsFromAccountManager";
        Account[] accountList = AccountManager.get((Context)parameters.getAppContext()).getAccountsByType("com.microsoft.workaccount");
        ArrayList<ICacheRecord> cacheRecords = new ArrayList<ICacheRecord>();
        Logger.verbose((String)(TAG + ":getBrokerAccountsFromAccountManager"), (String)("Retrieve all the accounts from account manager with broker account type, and the account length is: " + accountList.length));
        if (accountList == null || accountList.length == 0) {
            return cacheRecords;
        }
        Bundle bundle = new Bundle();
        bundle.putBoolean(DATA_CACHE_RECORD, true);
        bundle.putInt("caller.info.uid", Binder.getCallingUid());
        bundle.putString("account.clientid.key", parameters.getClientId());
        for (Account eachAccount : accountList) {
            AccountManagerFuture result = AccountManager.get((Context)parameters.getAppContext()).updateCredentials(eachAccount, "adal.authtoken.type", bundle, null, null, null);
            Bundle userInfoBundle = (Bundle)result.getResult();
            cacheRecords.addAll(MsalBrokerResultAdapter.accountsFromBundle((Bundle)userInfoBundle));
        }
        return cacheRecords;
    }

    @Override
    @WorkerThread
    @SuppressLint(value={"MissingPermission"})
    protected boolean removeBrokerAccount(@NonNull OperationParameters parameters) {
        String methodName = ":removeBrokerAccountFromAccountManager";
        Logger.verbose((String)(TAG + ":removeBrokerAccountFromAccountManager"), (String)"Try to remove account from account manager.");
        Account[] accountList = AccountManager.get((Context)parameters.getAppContext()).getAccountsByType("com.microsoft.workaccount");
        if (accountList != null && accountList.length > 0) {
            for (Account eachAccount : accountList) {
                if (parameters.getAccount() != null && !eachAccount.name.equalsIgnoreCase(parameters.getAccount().getUsername())) continue;
                Bundle brokerOptions = new Bundle();
                brokerOptions.putString("account.clientid.key", parameters.getClientId());
                brokerOptions.putString("environment", parameters.getAccount().getEnvironment());
                brokerOptions.putInt("caller.info.uid", Binder.getCallingUid());
                brokerOptions.putString("account.home.account.id", parameters.getAccount().getHomeAccountId());
                brokerOptions.putString("account.remove.tokens", "account.remove.tokens.value");
                AccountManager.get((Context)parameters.getAppContext()).getAuthToken(eachAccount, "adal.authtoken.type", brokerOptions, false, null, this.getPreferredHandler());
            }
        }
        return true;
    }
}

