/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.CurrentAccountResult;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.ICurrentAccountResult;
import com.microsoft.identity.client.ISingleAccountPublicClientApplication;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.SilentAuthenticationCallback;
import com.microsoft.identity.client.TokenParameters;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.AsyncResult;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.controllers.BrokerMsalController;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.client.internal.controllers.OperationParametersAdapter;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.controllers.ApiDispatcher;
import com.microsoft.identity.common.internal.controllers.LoadAccountCommand;
import com.microsoft.identity.common.internal.controllers.RemoveAccountCommand;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.ILocalAuthenticationCallback;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.result.ResultFuture;
import java.util.List;

public class SingleAccountPublicClientApplication
extends PublicClientApplication
implements ISingleAccountPublicClientApplication {
    private static final String TAG = SingleAccountPublicClientApplication.class.getSimpleName();
    public static final String SINGLE_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES = "com.microsoft.identity.client.single_account_credential_cache";
    public static final String CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY = "com.microsoft.identity.client.single_account_credential_cache.current_account";
    private SharedPreferencesFileManager sharedPreferencesFileManager;

    protected SingleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration config, @Nullable String clientId, @Nullable String authority, @NonNull Boolean isSharedDevice) {
        super(config, clientId, authority);
        this.initializeSharedPreferenceFileManager(config.getAppContext());
        this.mIsSharedDevice = isSharedDevice;
    }

    private void initializeSharedPreferenceFileManager(@NonNull Context context) {
        this.sharedPreferencesFileManager = new SharedPreferencesFileManager(context, SINGLE_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES, (IStorageHelper)new StorageHelper(context));
    }

    @Override
    public void getCurrentAccountAsync(final @NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback) {
        String methodName = ":getCurrentAccount";
        PublicClientApplicationConfiguration configuration = this.getConfiguration();
        try {
            if (this.mIsSharedDevice) {
                this.getCurrentAccountFromSharedDevice(callback, configuration);
                return;
            }
            Logger.verbose((String)(TAG + ":getCurrentAccount"), (String)"Getting the current account");
            OperationParameters params = OperationParametersAdapter.createOperationParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache());
            LoadAccountCommand command = new LoadAccountCommand(params, MSALControllerFactory.getAcquireTokenController(this.mPublicClientConfiguration.getAppContext(), params.getAuthority(), this.mPublicClientConfiguration), (TaskCompletedCallbackWithError)new TaskCompletedCallbackWithError<List<ICacheRecord>, BaseException>(){

                public void onTaskCompleted(List<ICacheRecord> result) {
                    SingleAccountPublicClientApplication.this.checkCurrentAccountNotifyCallback(callback, result);
                }

                public void onError(BaseException exception) {
                    Logger.error((String)(TAG + ":getCurrentAccount"), (String)exception.getMessage(), (Throwable)exception);
                    callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(exception));
                }
            });
            ApiDispatcher.getAccounts((LoadAccountCommand)command);
        }
        catch (MsalClientException clientException) {
            callback.onError(clientException);
        }
    }

    @Override
    public ICurrentAccountResult getCurrentAccount() throws InterruptedException, MsalException {
        MsalUtils.throwOnMainThread("getCurrentAccount");
        final ResultFuture future = new ResultFuture();
        this.getCurrentAccountAsync(new ISingleAccountPublicClientApplication.CurrentAccountCallback(){

            @Override
            public void onAccountLoaded(@Nullable IAccount activeAccount) {
                CurrentAccountResult currentAccountResult = new CurrentAccountResult(activeAccount, null, false);
                future.setResult(new AsyncResult<CurrentAccountResult>(currentAccountResult, null));
            }

            @Override
            public void onAccountChanged(@Nullable IAccount priorAccount, @Nullable IAccount currentAccount) {
                CurrentAccountResult currentAccountResult = new CurrentAccountResult(currentAccount, priorAccount, false);
                future.setResult(new AsyncResult<CurrentAccountResult>(currentAccountResult, null));
            }

            @Override
            public void onError(@NonNull MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        });
        AsyncResult result = (AsyncResult)future.get();
        if (result.getSuccess()) {
            return (ICurrentAccountResult)result.getResult();
        }
        throw result.getException();
    }

    private void getCurrentAccountFromSharedDevice(final @NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback, @NonNull PublicClientApplicationConfiguration configuration) {
        new BrokerMsalController().getCurrentAccount(configuration, configuration.getOAuth2TokenCache(), new TaskCompletedCallbackWithError<List<ICacheRecord>, MsalException>(){

            public void onTaskCompleted(List<ICacheRecord> cacheRecords) {
                SingleAccountPublicClientApplication.this.checkCurrentAccountNotifyCallback(callback, cacheRecords);
            }

            public void onError(MsalException exception) {
                callback.onError(exception);
            }
        });
    }

    private void checkCurrentAccountNotifyCallback(@NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback, @Nullable List<ICacheRecord> newAccountRecords) {
        MultiTenantAccount newAccount;
        MultiTenantAccount localAccount = this.getPersistedCurrentAccount();
        MultiTenantAccount multiTenantAccount = newAccount = newAccountRecords == null ? null : this.getAccountFromICacheRecordList(newAccountRecords);
        if (this.didCurrentAccountChange(newAccount)) {
            callback.onAccountChanged(localAccount, newAccount);
        }
        this.persistCurrentAccount(newAccountRecords);
        callback.onAccountLoaded(newAccount);
    }

    @Override
    public void signIn(@NonNull Activity activity, @NonNull String loginHint, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            callback.onError(new MsalClientException("invalid_parameter"));
            return;
        }
        this.acquireToken(activity, scopes, null, null, null, null, null, callback, loginHint, null);
    }

    @Override
    protected ILocalAuthenticationCallback getLocalAuthenticationCallback(final @NonNull SilentAuthenticationCallback authenticationCallback, final @NonNull TokenParameters tokenParameters) {
        return new ILocalAuthenticationCallback(){

            public void onSuccess(@NonNull ILocalAuthenticationResult localAuthenticationResult) {
                MultiTenantAccount newAccount = SingleAccountPublicClientApplication.this.getAccountFromICacheRecordList(localAuthenticationResult.getCacheRecordWithTenantProfileData());
                if (SingleAccountPublicClientApplication.this.didCurrentAccountChange(newAccount)) {
                    if (SingleAccountPublicClientApplication.this.getPersistedCurrentAccount() != null) {
                        authenticationCallback.onError(new MsalClientException("returned_account_does_not_match_current_account"));
                        return;
                    }
                    SingleAccountPublicClientApplication.this.persistCurrentAccount(localAuthenticationResult.getCacheRecordWithTenantProfileData());
                } else {
                    SingleAccountPublicClientApplication.this.persistCurrentAccount(localAuthenticationResult.getCacheRecordWithTenantProfileData());
                }
                SingleAccountPublicClientApplication.this.postAuthResult(localAuthenticationResult, tokenParameters, authenticationCallback);
            }

            public void onError(BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                authenticationCallback.onError(msalException);
            }

            public void onCancel() {
                if (!(authenticationCallback instanceof AuthenticationCallback)) {
                    throw new IllegalStateException("Silent requests cannot be cancelled.");
                }
                ((AuthenticationCallback)authenticationCallback).onCancel();
            }
        };
    }

    private boolean didCurrentAccountChange(@Nullable MultiTenantAccount newAccount) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        String persistedAccountId = persistedAccount == null ? "" : persistedAccount.getHomeAccountId();
        String newAccountId = newAccount == null ? "" : newAccount.getHomeAccountId();
        return !persistedAccountId.equalsIgnoreCase(newAccountId);
    }

    @Override
    public void signOut(final @NonNull ISingleAccountPublicClientApplication.SignOutCallback callback) {
        PublicClientApplicationConfiguration configuration = this.getConfiguration();
        MultiTenantAccount persistedCurrentAccount = this.getPersistedCurrentAccount();
        if (persistedCurrentAccount == null) {
            callback.onError(new MsalClientException("no_current_account"));
            return;
        }
        if (this.mIsSharedDevice) {
            this.removeAccountFromSharedDevice(callback, configuration);
            return;
        }
        try {
            OperationParameters params = OperationParametersAdapter.createOperationParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache());
            AccountRecord requestAccountRecord = new AccountRecord();
            requestAccountRecord.setEnvironment(persistedCurrentAccount.getEnvironment());
            requestAccountRecord.setHomeAccountId(persistedCurrentAccount.getHomeAccountId());
            params.setAccount((IAccountRecord)requestAccountRecord);
            RemoveAccountCommand command = new RemoveAccountCommand(params, MSALControllerFactory.getAcquireTokenController(this.mPublicClientConfiguration.getAppContext(), params.getAuthority(), this.mPublicClientConfiguration), (TaskCompletedCallbackWithError)new TaskCompletedCallbackWithError<Boolean, BaseException>(){

                public void onError(BaseException error) {
                    callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(error));
                }

                public void onTaskCompleted(Boolean result) {
                    SingleAccountPublicClientApplication.this.persistCurrentAccount(null);
                    callback.onSignOut();
                }
            });
            ApiDispatcher.removeAccount((RemoveAccountCommand)command);
        }
        catch (MsalClientException clientException) {
            callback.onError(clientException);
        }
    }

    @Override
    public boolean signOut() throws MsalException, InterruptedException {
        MsalUtils.throwOnMainThread("signOut");
        final ResultFuture future = new ResultFuture();
        this.signOut(new ISingleAccountPublicClientApplication.SignOutCallback(){

            @Override
            public void onSignOut() {
                future.setResult(new AsyncResult<Boolean>(true, null));
            }

            @Override
            public void onError(@NonNull MsalException exception) {
                future.setResult(new AsyncResult<Boolean>(false, exception));
            }
        });
        AsyncResult result = (AsyncResult)future.get();
        if (result.getSuccess()) {
            return (Boolean)result.getResult();
        }
        throw result.getException();
    }

    private void removeAccountFromSharedDevice(final @NonNull ISingleAccountPublicClientApplication.SignOutCallback callback, @NonNull PublicClientApplicationConfiguration configuration) {
        new BrokerMsalController().removeAccountFromSharedDevice(configuration, new TaskCompletedCallbackWithError<Void, MsalException>(){

            public void onTaskCompleted(Void aVoid) {
                SingleAccountPublicClientApplication.this.persistCurrentAccount(null);
                callback.onSignOut();
            }

            public void onError(MsalException exception) {
                callback.onError(exception);
            }
        });
    }

    private MultiTenantAccount getPersistedCurrentAccount() {
        String currentAccountJsonString = this.sharedPreferencesFileManager.getString(CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY);
        if (currentAccountJsonString == null) {
            return null;
        }
        List cacheRecordList = MsalBrokerResultAdapter.getICacheRecordListFromJsonString((String)currentAccountJsonString);
        return this.getAccountFromICacheRecordList(cacheRecordList);
    }

    private void persistCurrentAccount(@Nullable List<ICacheRecord> cacheRecords) {
        this.sharedPreferencesFileManager.clear();
        if (cacheRecords == null || cacheRecords.size() == 0) {
            return;
        }
        String currentAccountJsonString = MsalBrokerResultAdapter.getJsonStringFromICacheRecordList(cacheRecords);
        this.sharedPreferencesFileManager.putString(CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY, currentAccountJsonString);
    }

    @Nullable
    private MultiTenantAccount getAccountFromICacheRecordList(@NonNull List<ICacheRecord> cacheRecords) {
        String methodName = ":getAccountFromICacheRecords";
        if (cacheRecords == null || cacheRecords.size() == 0) {
            return null;
        }
        List<IAccount> account = AccountAdapter.adapt(cacheRecords);
        if (account.size() != 1) {
            Logger.verbose((String)(TAG + ":getAccountFromICacheRecords"), (String)"Returned cacheRecords were adapted into multiple IAccount. This is unexpected in Single account mode.Returning the first adapted account.");
        }
        return (MultiTenantAccount)account.get(0);
    }

    @Override
    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            callback.onError(new MsalClientException("no_current_account"));
            return;
        }
        this.acquireToken(activity, scopes, this.getPersistedCurrentAccount(), null, null, null, null, callback, null, null);
    }

    @Override
    public void acquireToken(@NonNull AcquireTokenParameters acquireTokenParameters) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            acquireTokenParameters.setAccount(persistedAccount);
            acquireTokenParameters.setLoginHint("");
        }
        super.acquireToken(acquireTokenParameters);
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull String authority, @NonNull SilentAuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            callback.onError(new MsalClientException("no_current_account"));
            return;
        }
        this.acquireTokenSilent(scopes, persistedAccount, authority, false, null, callback);
    }

    @Override
    @WorkerThread
    public IAuthenticationResult acquireTokenSilent(@NonNull String[] scopes, @NonNull String authority) throws MsalException, InterruptedException {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            throw new MsalClientException("no_current_account");
        }
        return this.acquireTokenSilentSync(scopes, authority, persistedAccount, false);
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            acquireTokenSilentParameters.getCallback().onError(new MsalClientException("no_current_account"));
            return;
        }
        acquireTokenSilentParameters.setAccount(persistedAccount);
        super.acquireTokenSilentAsync(acquireTokenSilentParameters);
    }

    @Override
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) throws InterruptedException, MsalException {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            throw new MsalClientException("no_current_account");
        }
        acquireTokenSilentParameters.setAccount(persistedAccount);
        return super.acquireTokenSilent(acquireTokenSilentParameters);
    }
}

