/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import androidx.annotation.NonNull;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.TokenParameters;
import com.microsoft.identity.client.TokenParametersAdapter;
import com.microsoft.identity.client.exception.MsalDeclinedScopeException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

class AuthenticationResultAdapter {
    private static final String TAG = AuthenticationResultAdapter.class.getName();

    AuthenticationResultAdapter() {
    }

    static IAuthenticationResult adapt(@NonNull ILocalAuthenticationResult localAuthenticationResult) {
        AuthenticationResult authenticationResult = new AuthenticationResult(localAuthenticationResult.getCacheRecordWithTenantProfileData());
        return authenticationResult;
    }

    static MsalDeclinedScopeException declinedScopeExceptionFromResult(@NonNull ILocalAuthenticationResult localAuthenticationResult, @NonNull List<String> declinedScopes, @NonNull TokenParameters requestParameters) {
        String methodName = ":declinedScopeExceptionFromResult";
        List<String> grantedScopes = Arrays.asList(localAuthenticationResult.getScope());
        Logger.warn((String)(TAG + ":declinedScopeExceptionFromResult"), (String)("Returning DeclinedScopeException as not all requested scopes are granted, Requested scopes: " + requestParameters.getScopes().toString() + " Granted scopes:" + grantedScopes.toString()));
        AcquireTokenSilentParameters silentParameters = requestParameters instanceof AcquireTokenSilentParameters ? (AcquireTokenSilentParameters)requestParameters : TokenParametersAdapter.silentParametersFromInteractive((AcquireTokenParameters)requestParameters, localAuthenticationResult);
        silentParameters.setScopes(grantedScopes);
        return new MsalDeclinedScopeException(grantedScopes, declinedScopes, silentParameters);
    }

    static List<String> getDeclinedScopes(@NonNull List<String> grantedScopes, @NonNull List<String> requestedScopes) {
        HashSet<String> grantedScopesSet = new HashSet<String>();
        for (String string : grantedScopes) {
            grantedScopesSet.add(string.toLowerCase());
        }
        HashSet<String> requestedScopesSet = new HashSet<String>();
        for (String requestedScope : requestedScopes) {
            requestedScopesSet.add(requestedScope.toLowerCase());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String requestedScope : requestedScopesSet) {
            if (grantedScopesSet.contains(requestedScope)) continue;
            arrayList.add(requestedScope);
        }
        return arrayList;
    }
}

