/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.telemetry;

import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.telemetry.Event;
import java.net.URL;

public final class HttpEvent
extends Event {
    private HttpEvent(Builder builder) {
        super(builder);
        this.setProperty("msal.user_agent", builder.mUserAgent);
        this.setProperty("msal.method", builder.mHttpMethod);
        this.setProperty("msal.query_params", builder.mQueryParams);
        this.setProperty("msal.api_version", builder.mApiVersion);
        this.setProperty("msal.oauth_error_code", builder.mOAuthErrorCode);
        this.setProperty("msal.x_ms_request_id", builder.mRequestIdHeader);
        if (null != builder.mHttpPath) {
            this.setHttpPath(builder.mHttpPath);
        }
        this.setProperty("msal.response_code", String.valueOf(builder.mResponseCode));
    }

    public static String sanitizeUrlForTelemetry(String url) {
        URL urlToSanitize = MsalUtils.getUrl(url);
        return urlToSanitize == null ? null : HttpEvent.sanitizeUrlForTelemetry(urlToSanitize);
    }

    public static String sanitizeUrlForTelemetry(URL url) {
        String authority = url.getAuthority();
        String[] splitArray = url.getPath().split("/");
        StringBuilder logPath = new StringBuilder();
        logPath.append(url.getProtocol()).append("://").append(authority).append('/');
        for (int i = 2; i < splitArray.length; ++i) {
            logPath.append(splitArray[i]);
            logPath.append('/');
        }
        return logPath.toString();
    }

    private void setHttpPath(URL httpPath) {
        this.setProperty("msal.http_path", HttpEvent.sanitizeUrlForTelemetry(httpPath));
    }

    public String getUserAgent() {
        return this.getProperty("msal.user_agent");
    }

    public String getHttpMethod() {
        return this.getProperty("msal.method");
    }

    public String getQueryParameters() {
        return this.getProperty("msal.query_params");
    }

    public String getApiVersion() {
        return this.getProperty("msal.api_version");
    }

    public String getOAuthErrorCode() {
        return this.getProperty("msal.oauth_error_code");
    }

    public String getRequestIdHeader() {
        return this.getProperty("msal.x_ms_request_id");
    }

    public URL getHttpPath() {
        return MsalUtils.getUrl(this.getProperty("msal.http_path"));
    }

    public Integer getResponseCode() {
        return Integer.valueOf(this.getProperty("msal.response_code"));
    }

    public static class Builder
    extends Event.Builder<Builder> {
        private String mUserAgent;
        private String mHttpMethod;
        private String mQueryParams;
        private String mApiVersion;
        private String mOAuthErrorCode;
        private String mRequestIdHeader;
        private URL mHttpPath;
        private Integer mResponseCode;

        public Builder() {
            super("msal.http_event");
        }

        public Builder setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public Builder setHttpMethod(String httpMethod) {
            this.mHttpMethod = httpMethod;
            return this;
        }

        public Builder setQueryParameters(String queryParams) {
            this.mQueryParams = queryParams;
            return this;
        }

        public Builder setApiVersion(String apiVersion) {
            this.mApiVersion = apiVersion;
            return this;
        }

        public Builder setOAuthErrorCode(String oAuthErrorCode) {
            this.mOAuthErrorCode = oAuthErrorCode;
            return this;
        }

        public Builder setRequestIdHeader(String requestIdHeader) {
            this.mRequestIdHeader = requestIdHeader;
            return this;
        }

        public Builder setHttpPath(URL httpPath) {
            this.mHttpPath = httpPath;
            return this;
        }

        public Builder setStatusCode(Integer responseCode) {
            this.mResponseCode = responseCode;
            return this;
        }

        @Override
        public HttpEvent build() {
            return new HttpEvent(this);
        }
    }
}

