/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.telemetry;

import com.microsoft.identity.client.internal.telemetry.Event;

public final class CacheEvent
extends Event {
    private CacheEvent(Builder builder) {
        super(builder);
        this.setProperty("msal.token_type", builder.mTokenType);
        this.setProperty("msal.is_at", String.valueOf(builder.mIsAT));
        this.setProperty("msal.is_rt", String.valueOf(builder.mIsRT));
    }

    public String getTokenType() {
        return this.getProperty("msal.token_type");
    }

    public boolean isRT() {
        return Boolean.valueOf(this.getProperty("msal.is_rt"));
    }

    public boolean isAT() {
        return Boolean.valueOf(this.getProperty("msal.is_at"));
    }

    public static class Builder
    extends Event.Builder<Builder> {
        private String mTokenType;
        private boolean mIsAT;
        private boolean mIsRT;

        public Builder(String eventName) {
            super(eventName);
        }

        public Builder setTokenType(String tokenType) {
            this.mTokenType = tokenType;
            return this;
        }

        public Builder setIsAT(boolean isAT) {
            this.mIsAT = isAT;
            return this;
        }

        public Builder setIsRT(boolean isRT) {
            this.mIsRT = isRT;
            return this;
        }

        @Override
        public CacheEvent build() {
            return new CacheEvent(this);
        }
    }
}

