/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;

public enum UiBehavior {
    SELECT_ACCOUNT,
    FORCE_LOGIN,
    CONSENT;


    public String toString() {
        switch (this) {
            case SELECT_ACCOUNT: {
                return SELECT_ACCOUNT.name().toLowerCase();
            }
            case FORCE_LOGIN: {
                return "login";
            }
            case CONSENT: {
                return CONSENT.name().toLowerCase();
            }
        }
        throw new IllegalArgumentException();
    }

    public OpenIdConnectPromptParameter toOpenIdConnectPromptParameter() {
        switch (this) {
            case SELECT_ACCOUNT: {
                return OpenIdConnectPromptParameter.SELECT_ACCOUNT;
            }
            case FORCE_LOGIN: {
                return OpenIdConnectPromptParameter.LOGIN;
            }
            case CONSENT: {
                return OpenIdConnectPromptParameter.CONSENT;
            }
        }
        return OpenIdConnectPromptParameter.SELECT_ACCOUNT;
    }
}

