/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Pair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.AzureActiveDirectoryAccountIdentifier;
import com.microsoft.identity.client.BrowserTabActivity;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.UiBehavior;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.configuration.LogLevelDeserializer;
import com.microsoft.identity.client.internal.controllers.BrokerMsalController;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.client.internal.controllers.OperationParametersAdapter;
import com.microsoft.identity.client.internal.telemetry.DefaultEvent;
import com.microsoft.identity.client.internal.telemetry.Defaults;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AuthorityDeserializer;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudienceDeserializer;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.Environment;
import com.microsoft.identity.common.internal.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.internal.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.cache.MicrosoftStsAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.controllers.ApiDispatcher;
import com.microsoft.identity.common.internal.controllers.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.controllers.TokenCommand;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.migration.AdalMigrationAdapter;
import com.microsoft.identity.common.internal.migration.IMigrationAdapter;
import com.microsoft.identity.common.internal.migration.TokenMigrationCallback;
import com.microsoft.identity.common.internal.migration.TokenMigrationUtility;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.ILocalAuthenticationCallback;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.msal.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PublicClientApplication {
    private static final String TAG = PublicClientApplication.class.getSimpleName();
    private static final String CLIENT_ID_META_DATA = "com.microsoft.identity.client.ClientId";
    private static final String AUTHORITY_META_DATA = "com.microsoft.identity.client.AuthorityMetadata";
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static final String ACCESS_NETWORK_STATE_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";
    private PublicClientApplicationConfiguration mPublicClientConfiguration;

    @Deprecated
    public PublicClientApplication(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null.");
        }
        this.setupConfiguration(context);
        this.loadMetaDataFromManifest();
        this.initializeApplication();
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    public PublicClientApplication(@NonNull Context context, int configFileResourceId) {
        if (context == null) {
            throw new IllegalArgumentException("context is null.");
        }
        PublicClientApplicationConfiguration developerConfig = PublicClientApplication.loadConfiguration(context, configFileResourceId);
        this.setupConfiguration(context, developerConfig);
        this.initializeApplication();
        AzureActiveDirectory.setEnvironment((Environment)this.mPublicClientConfiguration.getEnvironment());
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    public PublicClientApplication(@NonNull Context context, @NonNull File configFile) {
        if (null == context) {
            throw new IllegalArgumentException("context is null.");
        }
        if (null == configFile) {
            throw new IllegalArgumentException("config is null.");
        }
        PublicClientApplicationConfiguration developerConfig = PublicClientApplication.loadConfiguration(configFile);
        this.setupConfiguration(context, developerConfig);
        this.initializeApplication();
        AzureActiveDirectory.setEnvironment((Environment)this.mPublicClientConfiguration.getEnvironment());
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    public PublicClientApplication(@NonNull Context context, @NonNull String clientId) {
        if (context == null) {
            throw new IllegalArgumentException("Context is null");
        }
        if (MsalUtils.isEmpty(clientId)) {
            throw new IllegalArgumentException("client id is empty or null");
        }
        this.setupConfiguration(context);
        this.mPublicClientConfiguration.mClientId = clientId;
        this.initializeApplication();
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    public PublicClientApplication(@NonNull Context context, @NonNull String clientId, @NonNull String authority) {
        this(context, clientId);
        if (TextUtils.isEmpty((CharSequence)authority)) {
            throw new IllegalArgumentException("authority is empty or null");
        }
        this.mPublicClientConfiguration.getAuthorities().clear();
        Authority authorityObject = Authority.getAuthorityFromAuthorityUrl((String)authority);
        authorityObject.setDefault(Boolean.valueOf(true));
        this.mPublicClientConfiguration.getAuthorities().add(authorityObject);
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
        this.initializeApplication();
    }

    private void initializeApplication() {
        DefaultEvent.initializeDefaults(Defaults.forApplication(this.mPublicClientConfiguration.getAppContext(), this.mPublicClientConfiguration.getClientId()));
        this.mPublicClientConfiguration.mRedirectUri = this.createRedirectUri(this.mPublicClientConfiguration.getClientId());
        this.checkIntentFilterAddedToAppManifest();
        this.checkInternetPermission();
        Logger.info((String)TAG, (String)"Create new public client application.");
    }

    public static String getSdkVersion() {
        return "0.3.2-alpha";
    }

    public PublicClientApplicationConfiguration getConfiguration() {
        return this.mPublicClientConfiguration;
    }

    public void getAccounts(final @NonNull AccountsLoadedCallback callback) {
        ApiDispatcher.initializeDiagnosticContext();
        String methodName = ":getAccounts";
        List<AccountRecord> accounts = this.getLocalAccounts();
        final Handler handler = null != Looper.myLooper() && Looper.getMainLooper() != Looper.myLooper() ? new Handler(Looper.myLooper()) : new Handler(Looper.getMainLooper());
        if (accounts.isEmpty()) {
            StorageHelper storageHelper = new StorageHelper(this.mPublicClientConfiguration.getAppContext());
            SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(this.mPublicClientConfiguration.getAppContext(), "com.microsoft.aad.adal.cache", (IStorageHelper)storageHelper);
            Map credentials = sharedPreferencesFileManager.getAll();
            HashMap<String, String> redirects = new HashMap<String, String>();
            redirects.put(this.mPublicClientConfiguration.mClientId, this.mPublicClientConfiguration.mRedirectUri);
            new TokenMigrationUtility()._import((IMigrationAdapter)new AdalMigrationAdapter(this.mPublicClientConfiguration.getAppContext(), redirects, false), credentials, (IShareSingleSignOnState)this.mPublicClientConfiguration.getOAuth2TokenCache(), new TokenMigrationCallback(){

                public void onMigrationFinished(int numberOfAccountsMigrated) {
                    String extendedMethodName = ":onMigrationFinished";
                    Logger.info((String)(TAG + ":getAccounts" + ":onMigrationFinished"), (String)("Migrated [" + numberOfAccountsMigrated + "] accounts"));
                    if (MSALControllerFactory.brokerEligible(PublicClientApplication.this.mPublicClientConfiguration.getAppContext(), PublicClientApplication.this.mPublicClientConfiguration.getDefaultAuthority(), PublicClientApplication.this.mPublicClientConfiguration)) {
                        PublicClientApplication.this.postBrokerAndLocalAccountsResult(handler, callback);
                    } else {
                        PublicClientApplication.this.postLocalAccountsResult(handler, callback);
                    }
                }
            });
        } else {
            new AdalMigrationAdapter(this.mPublicClientConfiguration.getAppContext(), null, false).setMigrationStatus(true);
            if (MSALControllerFactory.brokerEligible(this.mPublicClientConfiguration.getAppContext(), this.mPublicClientConfiguration.getDefaultAuthority(), this.mPublicClientConfiguration)) {
                this.postBrokerAndLocalAccountsResult(handler, callback);
            } else {
                this.postLocalAccountsResult(handler, callback);
            }
        }
    }

    private void postLocalAccountsResult(Handler handler, final AccountsLoadedCallback callback) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList<IAccount> accountsToReturn = new ArrayList<IAccount>();
                for (AccountRecord accountRecord : PublicClientApplication.this.getLocalAccounts()) {
                    accountsToReturn.add(AccountAdapter.adapt((IAccountRecord)accountRecord));
                }
                callback.onAccountsLoaded(accountsToReturn);
            }
        });
    }

    private void postBrokerAndLocalAccountsResult(final Handler handler, final AccountsLoadedCallback callback) {
        String methodName = ":postBrokerAndLocalAccountsResult";
        new BrokerMsalController().getBrokerAccounts(this.mPublicClientConfiguration, new BrokerAccountsLoadedCallback(){

            @Override
            public void onAccountsLoaded(List<AccountRecord> accountRecords) {
                Logger.verbose((String)(TAG + ":postBrokerAndLocalAccountsResult"), (String)("Accounts loaded from broker " + (accountRecords == null ? 0 : accountRecords.size())));
                final ArrayList<IAccount> accountList = new ArrayList<IAccount>();
                ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>();
                if (accountRecords != null) {
                    accountRecordList.addAll(accountRecords);
                }
                accountRecordList.addAll(PublicClientApplication.this.getLocalAccounts());
                if (accountRecordList.size() > 0) {
                    for (AccountRecord accountRecord : accountRecordList) {
                        accountList.add(AccountAdapter.adapt((IAccountRecord)accountRecord));
                    }
                }
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onAccountsLoaded(accountList);
                    }
                });
            }
        });
    }

    private List<AccountRecord> getLocalAccounts() {
        List accountsInCache = this.mPublicClientConfiguration.getOAuth2TokenCache().getAccounts(null, this.mPublicClientConfiguration.getClientId());
        return accountsInCache;
    }

    @Nullable
    public IAccount getAccount(@NonNull String homeAccountIdentifier, @Nullable String authority) {
        String methodName = ":getAccount";
        ApiDispatcher.initializeDiagnosticContext();
        String realm = (String)StringUtil.getTenantInfo((String)homeAccountIdentifier).second;
        Authority authorityObj = Authority.getAuthorityFromAuthorityUrl((String)authority);
        if (authorityObj instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)authorityObj;
            AzureActiveDirectoryAudience audience = aadAuthority.getAudience();
            realm = audience.getTenantId();
        } else {
            Logger.warn((String)(TAG + ":getAccount"), (String)"Provided authority was not AAD - defaulting to parsed home_account_id");
        }
        AccountRecord accountToReturn = null;
        if (null != realm) {
            accountToReturn = AccountAdapter.getAccountInternal(this.mPublicClientConfiguration.getClientId(), this.mPublicClientConfiguration.getOAuth2TokenCache(), homeAccountIdentifier, realm);
        } else {
            Logger.warn((String)(TAG + ":getAccount"), (String)"Realm could not be resolved. Returning null.");
        }
        return null == accountToReturn ? null : AccountAdapter.adapt((IAccountRecord)accountToReturn);
    }

    public void removeAccount(@Nullable IAccount account, AccountsRemovedCallback callback) {
        boolean localRemoveAccountSuccess;
        ApiDispatcher.initializeDiagnosticContext();
        if (null == account || null == account.getHomeAccountIdentifier() || StringUtil.isEmpty((String)account.getHomeAccountIdentifier().getIdentifier())) {
            Logger.warn((String)TAG, (String)"Requisite IAccount or IAccount fields were null. Insufficient criteria to remove IAccount.");
            callback.onAccountsRemoved(false);
        }
        boolean deleteAccountsInAllTenants = true;
        String realm = null;
        boolean bl = localRemoveAccountSuccess = !this.mPublicClientConfiguration.getOAuth2TokenCache().removeAccount(account.getEnvironment(), this.mPublicClientConfiguration.getClientId(), account.getHomeAccountIdentifier().getIdentifier(), realm).isEmpty();
        if (MSALControllerFactory.brokerEligible(this.mPublicClientConfiguration.getAppContext(), this.mPublicClientConfiguration.getDefaultAuthority(), this.mPublicClientConfiguration)) {
            new BrokerMsalController().removeBrokerAccount(account, this.mPublicClientConfiguration, callback);
        } else {
            callback.onAccountsRemoved(localRemoveAccountSuccess);
        }
    }

    @Nullable
    private static String getRealm(@NonNull IAccount account) {
        String realm = null;
        if (null != account.getAccountIdentifier() && account.getAccountIdentifier() instanceof AzureActiveDirectoryAccountIdentifier) {
            AzureActiveDirectoryAccountIdentifier identifier = (AzureActiveDirectoryAccountIdentifier)account.getAccountIdentifier();
            realm = identifier.getTenantIdentifier();
        }
        return realm;
    }

    public void handleInteractiveRequestRedirect(int requestCode, int resultCode, @NonNull Intent data) {
        ApiDispatcher.completeInteractive((int)requestCode, (int)resultCode, (Intent)data);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        this.acquireToken(activity, scopes, null, null, null, null, null, callback, null, null);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable String loginHint, @NonNull AuthenticationCallback callback) {
        this.acquireToken(activity, scopes, null, null, null, null, null, callback, loginHint, null);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable String loginHint, @NonNull UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @NonNull AuthenticationCallback callback) {
        this.acquireToken(activity, scopes, null, uiBehavior, extraQueryParameters, null, null, callback, loginHint, null);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable IAccount account, @NonNull UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @NonNull AuthenticationCallback callback) {
        this.acquireToken(activity, scopes, account, uiBehavior, extraQueryParameters, null, null, callback, null, null);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable String loginHint, @Nullable UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @NonNull AuthenticationCallback callback) {
        this.acquireToken(activity, scopes, null, uiBehavior, extraQueryParameters, extraScopesToConsent, authority, callback, loginHint, null);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable IAccount account, @NonNull UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @NonNull AuthenticationCallback callback) {
        this.acquireToken(activity, scopes, account, uiBehavior, extraQueryParameters, extraScopesToConsent, authority, callback, null, null);
    }

    private void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable IAccount account, @Nullable UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @NonNull AuthenticationCallback callback, @Nullable String loginHint, @Nullable ClaimsRequest claimsRequest) {
        PublicClientApplication.validateNonNullArgument(activity, "Activity");
        PublicClientApplication.validateNonNullArgument(callback, "Callback");
        AcquireTokenParameters.Builder builder = new AcquireTokenParameters.Builder();
        AcquireTokenParameters acquireTokenParameters = ((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)builder.startAuthorizationFromActivity(activity).forAccount(account)).withScopes(Arrays.asList(scopes))).withUiBehavior(uiBehavior).withAuthorizationQueryStringParameters(extraQueryParameters).withOtherScopesToAuthorize(Arrays.asList(null == extraScopesToConsent ? new String[]{} : extraScopesToConsent)).fromAuthority(authority)).callback(callback)).withLoginHint(loginHint).withClaims(claimsRequest)).build();
        this.acquireTokenAsync(acquireTokenParameters);
    }

    private static void validateNonNullArgument(@Nullable Object o, @NonNull String argName) {
        if (null == o) {
            throw new IllegalArgumentException(argName + " cannot be null or empty");
        }
    }

    public void acquireTokenAsync(@NonNull AcquireTokenParameters acquireTokenParameters) {
        acquireTokenParameters.setAccountRecord(this.getAccountRecord(acquireTokenParameters.getAccount()));
        AcquireTokenOperationParameters params = OperationParametersAdapter.createAcquireTokenOperationParameters(acquireTokenParameters, this.mPublicClientConfiguration);
        ILocalAuthenticationCallback localAuthenticationCallback = PublicClientApplication.getLocalAuthenticationCallback(acquireTokenParameters.getCallback());
        InteractiveTokenCommand command = new InteractiveTokenCommand(params, MSALControllerFactory.getAcquireTokenController(this.mPublicClientConfiguration.getAppContext(), params.getAuthority(), this.mPublicClientConfiguration), localAuthenticationCallback);
        ApiDispatcher.beginInteractive((InteractiveTokenCommand)command);
    }

    private AccountRecord getAccountRecord(@Nullable IAccount account) {
        if (account != null) {
            return AccountAdapter.getAccountInternal(this.mPublicClientConfiguration.getClientId(), this.mPublicClientConfiguration.getOAuth2TokenCache(), account.getHomeAccountIdentifier().getIdentifier(), PublicClientApplication.getRealm(account));
        }
        return null;
    }

    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull IAccount account, @NonNull AuthenticationCallback callback) {
        this.acquireTokenSilent(scopes, account, null, false, null, callback);
    }

    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull IAccount account, @Nullable String authority, boolean forceRefresh, @NonNull AuthenticationCallback callback) {
        this.acquireTokenSilent(scopes, account, authority, forceRefresh, null, callback);
    }

    private void acquireTokenSilent(@NonNull String[] scopes, @NonNull IAccount account, @Nullable String authority, boolean forceRefresh, @Nullable ClaimsRequest claimsRequest, @NonNull AuthenticationCallback callback) {
        PublicClientApplication.validateNonNullArgument(account, "Account");
        PublicClientApplication.validateNonNullArgument(callback, "Callback");
        AcquireTokenSilentParameters.Builder builder = new AcquireTokenSilentParameters.Builder();
        AcquireTokenSilentParameters acquireTokenSilentParameters = ((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)builder.withScopes(Arrays.asList(scopes))).forAccount(account)).fromAuthority(authority)).forceRefresh(forceRefresh).withClaims(claimsRequest)).callback(callback)).build();
        this.acquireTokenSilentAsync(acquireTokenSilentParameters);
    }

    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) {
        acquireTokenSilentParameters.setAccountRecord(this.getAccountRecord(acquireTokenSilentParameters.getAccount()));
        AcquireTokenSilentOperationParameters params = OperationParametersAdapter.createAcquireTokenSilentOperationParameters(acquireTokenSilentParameters, this.mPublicClientConfiguration);
        ILocalAuthenticationCallback callback = PublicClientApplication.getLocalAuthenticationCallback(acquireTokenSilentParameters.getCallback());
        TokenCommand silentTokenCommand = new TokenCommand((OperationParameters)params, MSALControllerFactory.getAcquireTokenSilentControllers(this.mPublicClientConfiguration.getAppContext(), params.getAuthority(), this.mPublicClientConfiguration), callback);
        ApiDispatcher.submitSilent((TokenCommand)silentTokenCommand);
    }

    private void loadMetaDataFromManifest() {
        String clientId;
        String methodName = ":loadMetaDataFromManifest";
        Logger.verbose((String)(TAG + ":loadMetaDataFromManifest"), (String)"Loading metadata from manifest...");
        ApplicationInfo applicationInfo = MsalUtils.getApplicationInfo(this.mPublicClientConfiguration.getAppContext());
        if (applicationInfo == null || applicationInfo.metaData == null) {
            throw new IllegalArgumentException("No meta-data exists");
        }
        String authority = applicationInfo.metaData.getString(AUTHORITY_META_DATA);
        if (!MsalUtils.isEmpty(authority)) {
            this.mPublicClientConfiguration.getAuthorities().clear();
            this.mPublicClientConfiguration.getAuthorities().add(Authority.getAuthorityFromAuthorityUrl((String)authority));
        }
        if (MsalUtils.isEmpty(clientId = applicationInfo.metaData.getString(CLIENT_ID_META_DATA))) {
            throw new IllegalArgumentException("client id missing from manifest");
        }
        this.mPublicClientConfiguration.mClientId = clientId;
    }

    @VisibleForTesting
    static PublicClientApplicationConfiguration loadConfiguration(@NonNull Context context, int configResourceId) {
        InputStream configStream = context.getResources().openRawResource(configResourceId);
        boolean useDefaultConfigResourceId = configResourceId == R.raw.msal_default_config;
        return PublicClientApplication.loadConfiguration(configStream, useDefaultConfigResourceId);
    }

    @VisibleForTesting
    static PublicClientApplicationConfiguration loadConfiguration(@NonNull File configFile) {
        try {
            return PublicClientApplication.loadConfiguration(new FileInputStream(configFile), false);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Provided configuration file path=" + configFile.getPath() + " not found.");
        }
    }

    private void setupConfiguration(Context context) {
        this.mPublicClientConfiguration = this.loadDefaultConfiguration(context);
        this.mPublicClientConfiguration.setAppContext(context);
        this.mPublicClientConfiguration.setOAuth2TokenCache(this.getOAuth2TokenCache());
    }

    private static PublicClientApplicationConfiguration loadConfiguration(InputStream configStream, boolean isDefaultConfiguration) {
        byte[] buffer;
        try {
            buffer = new byte[configStream.available()];
            configStream.read(buffer);
        }
        catch (IOException e) {
            if (isDefaultConfiguration) {
                throw new IllegalStateException("Unable to open default configuration file.", e);
            }
            throw new IllegalArgumentException("Unable to open provided configuration file.", e);
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException e) {
                if (isDefaultConfiguration) {
                    Logger.warn((String)(TAG + "loadConfiguration"), (String)"Unable to close default configuration file. This can cause memory leak.");
                }
                Logger.warn((String)(TAG + "loadConfiguration"), (String)"Unable to close provided configuration file. This can cause memory leak.");
            }
        }
        String config = new String(buffer);
        Gson gson = PublicClientApplication.getGsonForLoadingConfiguration();
        return (PublicClientApplicationConfiguration)gson.fromJson(config, PublicClientApplicationConfiguration.class);
    }

    private void setupConfiguration(@NonNull Context context, PublicClientApplicationConfiguration developerConfig) {
        PublicClientApplicationConfiguration defaultConfig = this.loadDefaultConfiguration(context);
        defaultConfig.mergeConfiguration(developerConfig);
        defaultConfig.validateConfiguration();
        this.mPublicClientConfiguration = defaultConfig;
        this.mPublicClientConfiguration.setAppContext(context);
        this.mPublicClientConfiguration.setOAuth2TokenCache(this.getOAuth2TokenCache());
    }

    private PublicClientApplicationConfiguration loadDefaultConfiguration(@NonNull Context context) {
        String methodName = ":loadDefaultConfiguration";
        Logger.verbose((String)(TAG + ":loadDefaultConfiguration"), (String)"Loading default configuration");
        return PublicClientApplication.loadConfiguration(context, R.raw.msal_default_config);
    }

    private static Gson getGsonForLoadingConfiguration() {
        return new GsonBuilder().registerTypeAdapter(Authority.class, (Object)new AuthorityDeserializer()).registerTypeAdapter(AzureActiveDirectoryAudience.class, (Object)new AzureActiveDirectoryAudienceDeserializer()).registerTypeAdapter(Logger.LogLevel.class, (Object)new LogLevelDeserializer()).create();
    }

    private void checkIntentFilterAddedToAppManifest() {
        if (!MsalUtils.hasCustomTabRedirectActivity(this.mPublicClientConfiguration.getAppContext(), this.mPublicClientConfiguration.getRedirectUri())) {
            throw new IllegalStateException("Intent filter for: " + BrowserTabActivity.class.getSimpleName() + " is missing.  Please refer to the MSAL readme.");
        }
    }

    private void checkInternetPermission() {
        PackageManager packageManager = this.mPublicClientConfiguration.getAppContext().getPackageManager();
        if (packageManager.checkPermission(INTERNET_PERMISSION, this.mPublicClientConfiguration.getAppContext().getPackageName()) != 0 || packageManager.checkPermission(ACCESS_NETWORK_STATE_PERMISSION, this.mPublicClientConfiguration.getAppContext().getPackageName()) != 0) {
            throw new IllegalStateException("android.permission.Internet or android.permission.ACCESS_NETWORK_STATE is missing");
        }
    }

    private String createRedirectUri(String clientId) {
        String methodName = ":createRedirectUri";
        if (!StringUtil.isEmpty((String)this.mPublicClientConfiguration.getRedirectUri())) {
            Logger.verbose((String)(TAG + ":createRedirectUri"), (String)"Returning redirectUri from configuration");
            return this.mPublicClientConfiguration.getRedirectUri();
        }
        return "msal" + clientId + "://auth";
    }

    private MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> initCommonCache(@NonNull Context context) {
        String methodName = ":initCommonCache";
        Logger.verbose((String)(TAG + ":initCommonCache"), (String)"Initializing common cache");
        CacheKeyValueDelegate cacheKeyValueDelegate = new CacheKeyValueDelegate();
        StorageHelper storageHelper = new StorageHelper(context);
        SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(context, "com.microsoft.identity.client.account_credential_cache", (IStorageHelper)storageHelper);
        SharedPreferencesAccountCredentialCache accountCredentialCache = new SharedPreferencesAccountCredentialCache((ICacheKeyValueDelegate)cacheKeyValueDelegate, (ISharedPreferencesFileManager)sharedPreferencesFileManager);
        MicrosoftStsAccountCredentialAdapter accountCredentialAdapter = new MicrosoftStsAccountCredentialAdapter();
        return new MsalOAuth2TokenCache(context, (IAccountCredentialCache)accountCredentialCache, (IAccountCredentialAdapter)accountCredentialAdapter);
    }

    private static ILocalAuthenticationCallback getLocalAuthenticationCallback(final AuthenticationCallback authenticationCallback) {
        return new ILocalAuthenticationCallback(){

            public void onSuccess(ILocalAuthenticationResult localAuthenticationResult) {
                IAuthenticationResult authenticationResult = AuthenticationResultAdapter.adapt(localAuthenticationResult);
                authenticationCallback.onSuccess(authenticationResult);
            }

            public void onError(BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                authenticationCallback.onError(msalException);
            }

            public void onCancel() {
                authenticationCallback.onCancel();
            }
        };
    }

    private OAuth2TokenCache<?, ?, ?> getOAuth2TokenCache() {
        return this.initCommonCache(this.mPublicClientConfiguration.getAppContext());
    }

    public static interface BrokerAccountsLoadedCallback {
        public void onAccountsLoaded(List<AccountRecord> var1);
    }

    public static interface AccountsRemovedCallback {
        public void onAccountsRemoved(Boolean var1);
    }

    public static interface AccountsLoadedCallback {
        public void onAccountsLoaded(List<IAccount> var1);
    }
}

