/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.util.Pair;
import com.microsoft.identity.client.TokenParameters;
import com.microsoft.identity.client.UiBehavior;
import java.util.List;

public class AcquireTokenParameters
extends TokenParameters {
    private Activity mActivity;
    private String mLoginHint;
    private UiBehavior mUiBehavior;
    private List<String> mExtraScopesToConsent;
    private List<Pair<String, String>> mExtraQueryStringParameters;

    public AcquireTokenParameters(Builder builder) {
        super(builder);
        this.mActivity = builder.mActivity;
        this.mLoginHint = builder.mLoginHint;
        this.mUiBehavior = builder.mUiBehavior;
        this.mExtraScopesToConsent = builder.mExtraScopesToConsent;
        this.mExtraQueryStringParameters = builder.mExtraQueryStringParameters;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public void setLoginHint(String loginHint) {
        this.mLoginHint = loginHint;
    }

    public UiBehavior getUiBehavior() {
        return this.mUiBehavior;
    }

    public void setUiBehavior(UiBehavior uiBehavior) {
        this.mUiBehavior = uiBehavior;
    }

    public List<String> getExtraScopesToConsent() {
        return this.mExtraScopesToConsent;
    }

    public void setExtraScopesToConsent(List<String> extraScopesToConsent) {
        this.mExtraScopesToConsent = extraScopesToConsent;
    }

    public List<Pair<String, String>> getExtraQueryStringParameters() {
        return this.mExtraQueryStringParameters;
    }

    public void setExtraQueryStringParameters(List<Pair<String, String>> extraQueryStringParameters) {
        this.mExtraQueryStringParameters = extraQueryStringParameters;
    }

    public static class Builder
    extends TokenParameters.Builder<Builder> {
        private Activity mActivity;
        private String mLoginHint;
        private UiBehavior mUiBehavior;
        private List<String> mExtraScopesToConsent;
        private List<Pair<String, String>> mExtraQueryStringParameters;

        public Builder startAuthorizationFromActivity(Activity activity) {
            this.mActivity = activity;
            return this.self();
        }

        public Builder withLoginHint(String loginHint) {
            this.mLoginHint = loginHint;
            return this.self();
        }

        public Builder withUiBehavior(UiBehavior uiBehavior) {
            this.mUiBehavior = uiBehavior;
            return this.self();
        }

        public Builder withOtherScopesToAuthorize(List<String> scopes) {
            this.mExtraScopesToConsent = scopes;
            return this.self();
        }

        public Builder withAuthorizationQueryStringParameters(List<Pair<String, String>> parameters) {
            this.mExtraQueryStringParameters = parameters;
            return this.self();
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public AcquireTokenParameters build() {
            return new AcquireTokenParameters(this);
        }
    }
}

