/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.identity.client.Account;
import com.microsoft.identity.client.AccountIdentifier;
import com.microsoft.identity.client.AzureActiveDirectoryAccountIdentifier;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.util.StringUtil;

public class AccountAdapter {
    private static final String TAG = AccountAdapter.class.getSimpleName();

    @NonNull
    static IAccount adapt(final @NonNull IAccountRecord accountIn) {
        AccountIdentifier homeAccountId;
        AccountIdentifier accountId;
        String methodName = ":adapt";
        Account accountOut = new Account();
        if ("MSSTS".equals(accountIn.getAuthorityType())) {
            Logger.info((String)(TAG + ":adapt"), (String)"Account type is AAD");
            accountId = new AzureActiveDirectoryAccountIdentifier(){
                {
                    this.setIdentifier(accountIn.getLocalAccountId());
                    this.setObjectIdentifier(accountIn.getLocalAccountId());
                    this.setTenantIdentifier(accountIn.getRealm());
                }
            };
            homeAccountId = new AzureActiveDirectoryAccountIdentifier(){
                {
                    String homeAccountIdStr = accountIn.getHomeAccountId();
                    String[] components = homeAccountIdStr.split("\\.");
                    this.setIdentifier(homeAccountIdStr);
                    this.setObjectIdentifier(components[0]);
                    this.setTenantIdentifier(components[1]);
                }
            };
        } else {
            Logger.info((String)(TAG + ":adapt"), (String)"Account is non-AAD");
            accountId = new AccountIdentifier(){
                {
                    this.setIdentifier(accountIn.getLocalAccountId());
                }
            };
            homeAccountId = new AccountIdentifier(){
                {
                    this.setIdentifier(accountIn.getHomeAccountId());
                }
            };
        }
        accountOut.setAccountIdentifier(accountId);
        accountOut.setHomeAccountIdentifier(homeAccountId);
        accountOut.setUsername(accountIn.getUsername());
        accountOut.setEnvironment(accountIn.getEnvironment());
        Logger.verbosePII((String)(TAG + ":adapt"), (String)("Username: [" + accountIn.getUsername() + "]"));
        Logger.verbosePII((String)(TAG + ":adapt"), (String)("Environment: [" + accountIn.getEnvironment() + "]"));
        return accountOut;
    }

    @Nullable
    static AccountRecord getAccountInternal(@NonNull String clientId, @NonNull OAuth2TokenCache oAuth2TokenCache, @NonNull String homeAccountIdentifier, @Nullable String realm) {
        AccountRecord accountToReturn;
        if (!StringUtil.isEmpty((String)homeAccountIdentifier)) {
            accountToReturn = oAuth2TokenCache.getAccount(null, clientId, homeAccountIdentifier, realm);
        } else {
            Logger.warn((String)TAG, (String)"homeAccountIdentifier was null or empty -- invalid criteria");
            accountToReturn = null;
        }
        return accountToReturn;
    }
}

