/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AzureActiveDirectoryAccountIdentifier;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.HashSet;

public class OperationParametersAdapter {
    private static final String TAG = OperationParameters.class.getName();

    public static AcquireTokenOperationParameters createAcquireTokenOperationParameters(AcquireTokenParameters acquireTokenParameters, PublicClientApplicationConfiguration publicClientApplicationConfiguration) {
        String methodName = ":createAcquireTokenOperationParameters";
        AcquireTokenOperationParameters acquireTokenOperationParameters = new AcquireTokenOperationParameters();
        if (StringUtil.isEmpty((String)acquireTokenParameters.getAuthority())) {
            if (acquireTokenParameters.getAccount() != null) {
                acquireTokenOperationParameters.setAuthority(OperationParametersAdapter.getRequestAuthority(acquireTokenParameters.getAccount(), publicClientApplicationConfiguration));
            } else {
                acquireTokenOperationParameters.setAuthority(publicClientApplicationConfiguration.getDefaultAuthority());
            }
        } else {
            acquireTokenOperationParameters.setAuthority(Authority.getAuthorityFromAuthorityUrl((String)acquireTokenParameters.getAuthority()));
        }
        if (acquireTokenOperationParameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)acquireTokenOperationParameters.getAuthority();
            aadAuthority.setMultipleCloudsSupported(publicClientApplicationConfiguration.getMultipleCloudsSupported());
        }
        Logger.verbosePII((String)":createAcquireTokenOperationParameters", (String)("Using authority: [" + acquireTokenOperationParameters.getAuthority().getAuthorityUri() + "]"));
        acquireTokenOperationParameters.setScopes(new HashSet(acquireTokenParameters.getScopes()));
        acquireTokenOperationParameters.setClientId(publicClientApplicationConfiguration.getClientId());
        acquireTokenOperationParameters.setRedirectUri(publicClientApplicationConfiguration.getRedirectUri());
        acquireTokenOperationParameters.setActivity(acquireTokenParameters.getActivity());
        if (acquireTokenParameters.getAccount() != null) {
            acquireTokenOperationParameters.setLoginHint(acquireTokenParameters.getAccount().getUsername());
            acquireTokenOperationParameters.setAccount((IAccountRecord)acquireTokenParameters.getAccountRecord());
        } else {
            acquireTokenOperationParameters.setLoginHint(acquireTokenParameters.getLoginHint());
        }
        acquireTokenOperationParameters.setTokenCache(publicClientApplicationConfiguration.getOAuth2TokenCache());
        acquireTokenOperationParameters.setExtraQueryStringParameters(acquireTokenParameters.getExtraQueryStringParameters());
        acquireTokenOperationParameters.setExtraScopesToConsent(acquireTokenParameters.getExtraScopesToConsent());
        acquireTokenOperationParameters.setAppContext(publicClientApplicationConfiguration.getAppContext());
        acquireTokenOperationParameters.setClaimsRequest(ClaimsRequest.getJsonStringFromClaimsRequest(acquireTokenParameters.getClaimsRequest()));
        if (null != publicClientApplicationConfiguration.getAuthorizationAgent()) {
            acquireTokenOperationParameters.setAuthorizationAgent(publicClientApplicationConfiguration.getAuthorizationAgent());
        } else {
            acquireTokenOperationParameters.setAuthorizationAgent(AuthorizationAgent.DEFAULT);
        }
        if (acquireTokenParameters.getUiBehavior() == null) {
            acquireTokenOperationParameters.setOpenIdConnectPromptParameter(OpenIdConnectPromptParameter.SELECT_ACCOUNT);
        } else {
            acquireTokenOperationParameters.setOpenIdConnectPromptParameter(acquireTokenParameters.getUiBehavior().toOpenIdConnectPromptParameter());
        }
        Context context = acquireTokenParameters.getActivity().getApplicationContext();
        acquireTokenOperationParameters.setApplicationName(context.getPackageName());
        acquireTokenOperationParameters.setApplicationVersion(OperationParametersAdapter.getPackageVersion(context));
        acquireTokenOperationParameters.setSdkVersion(PublicClientApplication.getSdkVersion());
        return acquireTokenOperationParameters;
    }

    public static AcquireTokenSilentOperationParameters createAcquireTokenSilentOperationParameters(AcquireTokenSilentParameters acquireTokenSilentParameters, PublicClientApplicationConfiguration publicClientApplicationConfiguration) {
        AcquireTokenSilentOperationParameters acquireTokenSilentOperationParameters = new AcquireTokenSilentOperationParameters();
        acquireTokenSilentOperationParameters.setAppContext(publicClientApplicationConfiguration.getAppContext());
        acquireTokenSilentOperationParameters.setScopes(new HashSet(acquireTokenSilentParameters.getScopes()));
        acquireTokenSilentOperationParameters.setClientId(publicClientApplicationConfiguration.getClientId());
        acquireTokenSilentOperationParameters.setTokenCache(publicClientApplicationConfiguration.getOAuth2TokenCache());
        if (null != acquireTokenSilentParameters.getAccountRecord()) {
            acquireTokenSilentOperationParameters.setAccount((IAccountRecord)acquireTokenSilentParameters.getAccountRecord());
        } else if (null != acquireTokenSilentParameters.getAccount()) {
            IAccount account = acquireTokenSilentParameters.getAccount();
            AccountRecord requestAccountRecord = new AccountRecord();
            requestAccountRecord.setEnvironment(account.getEnvironment());
            requestAccountRecord.setUsername(account.getUsername());
            requestAccountRecord.setHomeAccountId(account.getHomeAccountIdentifier().getIdentifier());
            requestAccountRecord.setAlternativeAccountId(account.getAccountIdentifier().getIdentifier());
            acquireTokenSilentOperationParameters.setAccount((IAccountRecord)requestAccountRecord);
        }
        if (StringUtil.isEmpty((String)acquireTokenSilentParameters.getAuthority())) {
            acquireTokenSilentParameters.setAuthority(OperationParametersAdapter.getSilentRequestAuthority(acquireTokenSilentParameters.getAccount(), publicClientApplicationConfiguration));
        }
        acquireTokenSilentOperationParameters.setAuthority(Authority.getAuthorityFromAuthorityUrl((String)acquireTokenSilentParameters.getAuthority()));
        acquireTokenSilentOperationParameters.setRedirectUri(publicClientApplicationConfiguration.getRedirectUri());
        if (acquireTokenSilentOperationParameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)acquireTokenSilentOperationParameters.getAuthority();
            aadAuthority.setMultipleCloudsSupported(publicClientApplicationConfiguration.getMultipleCloudsSupported());
        }
        acquireTokenSilentOperationParameters.setClaimsRequest(ClaimsRequest.getJsonStringFromClaimsRequest(acquireTokenSilentParameters.getClaimsRequest()));
        acquireTokenSilentOperationParameters.setForceRefresh(acquireTokenSilentParameters.getForceRefresh().booleanValue());
        Context context = publicClientApplicationConfiguration.getAppContext();
        acquireTokenSilentOperationParameters.setApplicationName(context.getPackageName());
        acquireTokenSilentOperationParameters.setApplicationVersion(OperationParametersAdapter.getPackageVersion(context));
        acquireTokenSilentOperationParameters.setSdkVersion(PublicClientApplication.getSdkVersion());
        return acquireTokenSilentOperationParameters;
    }

    private static Authority getRequestAuthority(IAccount account, PublicClientApplicationConfiguration publicClientApplicationConfiguration) {
        String requestAuthority = null;
        if (publicClientApplicationConfiguration.getDefaultAuthority() instanceof AzureActiveDirectoryB2CAuthority) {
            requestAuthority = publicClientApplicationConfiguration.getDefaultAuthority().getAuthorityURL().toString();
        }
        if (requestAuthority == null) {
            requestAuthority = OperationParametersAdapter.getAuthorityFromAccount(account);
        }
        Authority authority = requestAuthority == null ? publicClientApplicationConfiguration.getDefaultAuthority() : Authority.getAuthorityFromAuthorityUrl((String)requestAuthority);
        return authority;
    }

    private static String getSilentRequestAuthority(IAccount account, PublicClientApplicationConfiguration publicClientApplicationConfiguration) {
        String requestAuthority = null;
        if (publicClientApplicationConfiguration.getDefaultAuthority() instanceof AzureActiveDirectoryB2CAuthority) {
            requestAuthority = publicClientApplicationConfiguration.getDefaultAuthority().getAuthorityURL().toString();
        }
        if (requestAuthority == null) {
            requestAuthority = OperationParametersAdapter.getAuthorityFromAccount(account);
        }
        if (requestAuthority == null) {
            requestAuthority = publicClientApplicationConfiguration.getDefaultAuthority().getAuthorityURL().toString();
        }
        return requestAuthority;
    }

    public static String getAuthorityFromAccount(IAccount account) {
        AzureActiveDirectoryAccountIdentifier aadIdentifier;
        String methodName = ":getAuthorityFromAccount";
        Logger.verbose((String)(TAG + ":getAuthorityFromAccount"), (String)"Getting authority from account...");
        if (null != account && null != account.getAccountIdentifier() && account.getAccountIdentifier() instanceof AzureActiveDirectoryAccountIdentifier && null != (aadIdentifier = (AzureActiveDirectoryAccountIdentifier)account.getAccountIdentifier()).getTenantIdentifier() && !StringUtil.isEmpty((String)aadIdentifier.getTenantIdentifier())) {
            return "https://" + account.getEnvironment() + "/" + aadIdentifier.getTenantIdentifier() + "/";
        }
        Logger.warn((String)(TAG + ":getAuthorityFromAccount"), (String)"Account was null...");
        return null;
    }

    private static String getPackageVersion(@NonNull Context context) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

