/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.Context;
import android.support.annotation.NonNull;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.internal.controllers.BrokerMsalController;
import com.microsoft.identity.client.internal.controllers.LocalMSALController;
import com.microsoft.identity.common.internal.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.controllers.BaseController;
import java.util.ArrayList;
import java.util.List;

public class MSALControllerFactory {
    public static BaseController getAcquireTokenController(@NonNull Context applicationContext, @NonNull Authority authority, @NonNull PublicClientApplicationConfiguration applicationConfiguration) {
        if (MSALControllerFactory.brokerEligible(applicationContext, authority, applicationConfiguration)) {
            return new BrokerMsalController();
        }
        return new LocalMSALController();
    }

    public static List<BaseController> getAcquireTokenSilentControllers(@NonNull Context applicationContext, @NonNull Authority authority, @NonNull PublicClientApplicationConfiguration applicationConfiguration) {
        ArrayList<BaseController> controllers = new ArrayList<BaseController>();
        controllers.add(new LocalMSALController());
        if (MSALControllerFactory.brokerEligible(applicationContext, authority, applicationConfiguration)) {
            controllers.add(new BrokerMsalController());
        }
        return controllers;
    }

    public static boolean brokerEligible(@NonNull Context applicationContext, @NonNull Authority authority, @NonNull PublicClientApplicationConfiguration applicationConfiguration) {
        if (!applicationConfiguration.getUseBroker().booleanValue() || !(authority instanceof AzureActiveDirectoryAuthority)) {
            return false;
        }
        AzureActiveDirectoryAuthority azureActiveDirectoryAuthority = (AzureActiveDirectoryAuthority)authority;
        if (azureActiveDirectoryAuthority.getAudience() instanceof AnyPersonalAccount) {
            return false;
        }
        return MSALControllerFactory.brokerInstalled(applicationContext);
    }

    private static boolean brokerInstalled(@NonNull Context applicationContext) {
        AuthenticatorDescription[] authenticators;
        BrokerValidator brokerValidator = new BrokerValidator(applicationContext);
        AccountManager accountManager = AccountManager.get((Context)applicationContext);
        for (AuthenticatorDescription authenticator : authenticators = accountManager.getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount") || !brokerValidator.verifySignature(authenticator.packageName)) continue;
            return true;
        }
        return false;
    }
}

