/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.microsoft.identity.client.BrowserTabActivity;
import com.microsoft.identity.common.adal.internal.net.HttpWebRequest;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.IResult;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.ui.AuthorizationStrategyFactory;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LocalMSALController
extends BaseController {
    private static final String TAG = LocalMSALController.class.getSimpleName();
    private AuthorizationStrategy mAuthorizationStrategy = null;
    private AuthorizationRequest mAuthorizationRequest = null;

    public AcquireTokenResult acquireToken(@NonNull AcquireTokenOperationParameters parameters) throws ExecutionException, InterruptedException, ClientException, IOException, ArgumentException {
        String methodName = ":acquireToken";
        Logger.verbose((String)(TAG + ":acquireToken"), (String)"Acquiring token...");
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        parameters.validate();
        this.addDefaultScopes((OperationParameters)parameters);
        this.logParameters(TAG, parameters);
        HttpWebRequest.throwIfNetworkNotAvailable((Context)parameters.getAppContext());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult((Authority)parameters.getAuthority());
        if (!authorityResult.getKnown()) {
            throw authorityResult.getClientException();
        }
        OAuth2Strategy oAuth2Strategy = parameters.getAuthority().createOAuth2Strategy();
        AuthorizationResult result = this.performAuthorizationRequest(oAuth2Strategy, parameters);
        acquireTokenResult.setAuthorizationResult(result);
        LocalMSALController.logResult((String)TAG, (IResult)result);
        if (result.getAuthorizationStatus().equals((Object)AuthorizationStatus.SUCCESS)) {
            TokenResult tokenResult = this.performTokenRequest(oAuth2Strategy, this.mAuthorizationRequest, result.getAuthorizationResponse(), parameters);
            acquireTokenResult.setTokenResult(tokenResult);
            if (tokenResult != null && tokenResult.getSuccess()) {
                ICacheRecord cacheRecord = this.saveTokens(oAuth2Strategy, this.mAuthorizationRequest, tokenResult.getTokenResponse(), parameters.getTokenCache());
                acquireTokenResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(cacheRecord));
            }
        }
        return acquireTokenResult;
    }

    private AuthorizationResult performAuthorizationRequest(@NonNull OAuth2Strategy strategy, @NonNull AcquireTokenOperationParameters parameters) throws ExecutionException, InterruptedException, ClientException {
        AuthorizationResult result;
        HttpWebRequest.throwIfNetworkNotAvailable((Context)parameters.getAppContext());
        Intent resultIntent = new Intent((Context)parameters.getActivity(), BrowserTabActivity.class);
        this.mAuthorizationStrategy = AuthorizationStrategyFactory.getInstance().getAuthorizationStrategy(parameters.getActivity(), parameters.getAuthorizationAgent(), resultIntent);
        this.mAuthorizationRequest = this.getAuthorizationRequest(strategy, (OperationParameters)parameters);
        Future future = strategy.requestAuthorization(this.mAuthorizationRequest, this.mAuthorizationStrategy);
        try {
            result = (AuthorizationResult)future.get(10L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            Logger.error((String)TAG, (String)"Auth Request could not be completed in 10", (Throwable)e);
            throw new ClientException("User failed to complete Auth Request in maximum allotted time", e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        String methodName = ":completeAcquireToken";
        Logger.verbose((String)(TAG + ":completeAcquireToken"), (String)"Completing acquire token...");
        this.mAuthorizationStrategy.completeAuthorization(requestCode, resultCode, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AcquireTokenResult acquireTokenSilent(@NonNull AcquireTokenSilentOperationParameters parameters) throws IOException, ClientException, ArgumentException {
        String methodName = ":acquireTokenSilent";
        Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Acquiring token silently...");
        AcquireTokenResult acquireTokenSilentResult = new AcquireTokenResult();
        parameters.validate();
        this.addDefaultScopes((OperationParameters)parameters);
        OAuth2TokenCache tokenCache = parameters.getTokenCache();
        AccountRecord targetAccount = this.getCachedAccountRecord(parameters);
        OAuth2Strategy strategy = parameters.getAuthority().createOAuth2Strategy();
        ICacheRecord cacheRecord = tokenCache.load(parameters.getClientId(), TextUtils.join((CharSequence)" ", (Iterable)parameters.getScopes()), targetAccount);
        if (this.accessTokenIsNull(cacheRecord) || this.refreshTokenIsNull(cacheRecord) || parameters.getForceRefresh()) {
            if (this.refreshTokenIsNull(cacheRecord)) throw new ClientException("no_tokens_found", "No refresh token was found. ");
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"No access token found, but RT is available.");
            this.renewAccessToken(parameters, acquireTokenSilentResult, tokenCache, strategy, cacheRecord);
            return acquireTokenSilentResult;
        } else if (cacheRecord.getAccessToken().isExpired()) {
            Logger.warn((String)(TAG + ":acquireTokenSilent"), (String)"Access token is expired. Removing from cache...");
            tokenCache.removeCredential((Credential)cacheRecord.getAccessToken());
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Renewing access token...");
            this.renewAccessToken(parameters, acquireTokenSilentResult, tokenCache, strategy, cacheRecord);
            return acquireTokenSilentResult;
        } else {
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Returning silent result");
            acquireTokenSilentResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(cacheRecord));
        }
        return acquireTokenSilentResult;
    }
}

