/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IMicrosoftAuthService;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.internal.controllers.BrokerActivity;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.BrokerResultFuture;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthServiceFuture;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    private BrokerResultFuture mBrokerResultFuture;
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();

    public AcquireTokenResult acquireToken(AcquireTokenOperationParameters parameters) throws InterruptedException, BaseException {
        this.mBrokerResultFuture = new BrokerResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        MsalBrokerRequestAdapter msalBrokerRequestAdapter = new MsalBrokerRequestAdapter();
        interactiveRequestIntent.putExtra("broker_request_v2", new Gson().toJson((Object)msalBrokerRequestAdapter.brokerRequestFromAcquireTokenParameters(parameters), BrokerRequest.class));
        Intent brokerActivityIntent = new Intent(parameters.getAppContext(), BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        parameters.getActivity().startActivity(brokerActivityIntent);
        Bundle resultBundle = this.mBrokerResultFuture.get();
        this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getTokenCache());
        return this.getAcquireTokenResult(resultBundle);
    }

    private Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters parameters) throws ClientException {
        Intent interactiveRequestIntent;
        MicrosoftAuthClient client = new MicrosoftAuthClient(parameters.getAppContext());
        MicrosoftAuthServiceFuture authServiceFuture = client.connect();
        try {
            IMicrosoftAuthService service = authServiceFuture.get();
            interactiveRequestIntent = service.getIntentForInteractiveRequest();
        }
        catch (RemoteException e) {
            throw new ClientException("Failed to bind the service in broker app", "Exception occurred while attempting to invoke remote service", (Throwable)e);
        }
        catch (Exception e) {
            throw new ClientException("Failed to bind the service in broker app", "Exception occurred while awaiting (get) return of MicrosoftAuthService", (Throwable)e);
        }
        finally {
            client.disconnect();
        }
        return interactiveRequestIntent;
    }

    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        this.mBrokerResultFuture.setResultBundle(data.getExtras());
    }

    public AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters parameters) throws BaseException {
        IMicrosoftAuthService service;
        MicrosoftAuthClient client = new MicrosoftAuthClient(parameters.getAppContext());
        MicrosoftAuthServiceFuture future = client.connect();
        try {
            service = future.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while awaiting (get) return of MicrosoftAuthService", e);
        }
        try {
            MsalBrokerRequestAdapter msalBrokerRequestAdapter = new MsalBrokerRequestAdapter();
            Bundle requestBundle = new Bundle();
            BrokerRequest brokerRequest = msalBrokerRequestAdapter.brokerRequestFromSilentOperationParameters(parameters);
            requestBundle.putString("broker_request_v2", new Gson().toJson((Object)brokerRequest, BrokerRequest.class));
            Bundle resultBundle = service.acquireTokenSilently(requestBundle);
            AcquireTokenResult acquireTokenResult = this.getAcquireTokenResult(resultBundle);
            return acquireTokenResult;
        }
        catch (RemoteException e) {
            throw new ClientException("Failed to bind the service in broker app", "Exception occurred while attempting to invoke remote service", (Throwable)e);
        }
        finally {
            client.disconnect();
        }
    }

    private AcquireTokenResult getAcquireTokenResult(Bundle resultBundle) throws BaseException {
        MsalBrokerResultAdapter resultAdapter = new MsalBrokerResultAdapter();
        if (resultBundle.getBoolean("broker_request_v2_success")) {
            Logger.verbose((String)TAG, (String)"Successful result from the broker ");
            AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
            acquireTokenResult.setLocalAuthenticationResult(resultAdapter.authenticationResultFromBundle(resultBundle));
            return acquireTokenResult;
        }
        Logger.warn((String)TAG, (String)"Exception returned from broker, retrieving exception details ");
        throw resultAdapter.baseExceptionFromBundle(resultBundle);
    }

    private void saveMsaAccountToCache(@NonNull Bundle resultBundle, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws ClientException {
        String methodName = ":saveMsaAccountToCache";
        BrokerResult brokerResult = (BrokerResult)resultBundle.getSerializable("broker_result_v2");
        if (resultBundle.getBoolean("broker_request_v2_success") && brokerResult != null && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info((String)(TAG + ":saveMsaAccountToCache"), (String)"Result returned for MSA Account, saving to cache");
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                msalOAuth2TokenCache.setSingleSignOnState((BaseAccount)microsoftStsAccount, (RefreshToken)microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII((String)(TAG + ":saveMsaAccountToCache"), (String)"Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", (Throwable)e);
                throw new ClientException("invalid_jwt", e.getMessage(), (Throwable)e);
            }
        }
    }

    public void getBrokerAccounts(final PublicClientApplicationConfiguration configuration, final PublicClientApplication.BrokerAccountsLoadedCallback callback) {
        String methodName = ":getBrokerAccounts";
        final Handler handler = new Handler(Looper.getMainLooper());
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MicrosoftAuthClient client = new MicrosoftAuthClient(configuration.getAppContext());
                try {
                    MicrosoftAuthServiceFuture authServiceFuture = client.connect();
                    IMicrosoftAuthService service = authServiceFuture.get();
                    Bundle requestBundle = BrokerMsalController.this.getRequestBundleForGetAccounts(configuration);
                    final List accountRecords = MsalBrokerResultAdapter.getAccountRecordListFromBundle((Bundle)service.getAccounts(requestBundle));
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onAccountsLoaded(accountRecords);
                        }
                    });
                }
                catch (RemoteException | ClientException | InterruptedException | ExecutionException e) {
                    Logger.error((String)(TAG + ":getBrokerAccounts"), (String)("Exception is thrown when trying to get account from Broker, returning empty list." + e.getMessage()), (String)"io_error", (Throwable)e);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onAccountsLoaded(new ArrayList<AccountRecord>());
                        }
                    });
                }
                finally {
                    client.disconnect();
                }
            }
        }).start();
    }

    private Bundle getRequestBundleForGetAccounts(@NonNull PublicClientApplicationConfiguration configuration) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", configuration.getClientId());
        requestBundle.putString("account.redirect", configuration.getRedirectUri());
        return requestBundle;
    }

    public void removeBrokerAccount(final @Nullable IAccount account, final @NonNull PublicClientApplicationConfiguration configuration, final @NonNull PublicClientApplication.AccountsRemovedCallback callback) {
        sBackgroundExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MicrosoftAuthClient client = new MicrosoftAuthClient(configuration.getAppContext());
                try {
                    MicrosoftAuthServiceFuture authServiceFuture = client.connect();
                    IMicrosoftAuthService service = authServiceFuture.get();
                    Bundle requestBundle = BrokerMsalController.this.getRequestBundleForRemoveAccount(account, configuration);
                    service.removeAccount(requestBundle);
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onAccountsRemoved(true);
                        }
                    });
                }
                catch (RemoteException | BaseException | InterruptedException | ExecutionException e) {
                    Logger.error((String)TAG, (String)("Exception is thrown when trying to get target account." + e.getMessage()), (String)"io_error", (Throwable)e);
                }
                finally {
                    client.disconnect();
                }
            }
        });
    }

    private Bundle getRequestBundleForRemoveAccount(@Nullable IAccount account, @NonNull PublicClientApplicationConfiguration configuration) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", configuration.getClientId());
        if (null != account) {
            requestBundle.putString("environment", account.getEnvironment());
            requestBundle.putString("account.login.hint", account.getUsername());
        }
        return requestBundle;
    }
}

