/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.Uri;
import android.util.Base64;
import com.microsoft.identity.client.BrowserTabActivity;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public final class MsalUtils {
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final int DEFAULT_EXPIRATION_TIME_SEC = 3600;
    private static final String TAG = MsalUtils.class.getSimpleName();
    private static final String TOKEN_HASH_ALGORITHM = "SHA256";
    public static final String CHROME_PACKAGE = "com.android.chrome";
    public static final String QUERY_STRING_SYMBOL = "?";
    public static final String QUERY_STRING_DELIMITER = "&";

    private MsalUtils() {
    }

    public static boolean isEmpty(String message) {
        return message == null || message.trim().length() == 0;
    }

    public static String urlFormEncode(String stringToEncode) throws UnsupportedEncodingException {
        if (MsalUtils.isEmpty(stringToEncode)) {
            return "";
        }
        return URLEncoder.encode(stringToEncode, ENCODING_UTF8);
    }

    public static String urlFormDecode(String source) throws UnsupportedEncodingException {
        if (MsalUtils.isEmpty(source)) {
            return "";
        }
        return URLDecoder.decode(source, ENCODING_UTF8);
    }

    public static Map<String, String> extractJsonObjectIntoMap(String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keyIterator = jsonObject.keys();
        HashMap<String, String> responseItems = new HashMap<String, String>();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            responseItems.put(key, jsonObject.getString(key));
        }
        return Collections.unmodifiableMap(responseItems);
    }

    public static Date calculateExpiresOn(String expiresIn) {
        GregorianCalendar expires = new GregorianCalendar();
        ((Calendar)expires).add(13, MsalUtils.getExpiryOrDefault(expiresIn));
        return expires.getTime();
    }

    public static int getExpiryOrDefault(String expiresIn) {
        return MsalUtils.isEmpty(expiresIn) ? 3600 : Integer.parseInt(expiresIn);
    }

    public static Set<String> getScopesAsSet(String scopes) {
        if (MsalUtils.isEmpty(scopes)) {
            return new HashSet<String>();
        }
        String[] scopeArray = scopes.toLowerCase(Locale.US).split(" ");
        HashSet<String> resultSet = new HashSet<String>();
        for (int i = 0; i < scopeArray.length; ++i) {
            if (MsalUtils.isEmpty(scopeArray[i])) continue;
            resultSet.add(scopeArray[i]);
        }
        return resultSet;
    }

    public static boolean hasCustomTabRedirectActivity(Context context, String url) {
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setDataAndNormalize(Uri.parse((String)url));
        List resolveInfoList = packageManager.queryIntentActivities(intent, 64);
        boolean hasActivity = false;
        for (ResolveInfo info : resolveInfoList) {
            ActivityInfo activityInfo = info.activityInfo;
            if (activityInfo.name.equals(BrowserTabActivity.class.getName())) {
                hasActivity = true;
                continue;
            }
            return false;
        }
        return hasActivity;
    }

    public static String getChromePackageWithCustomTabSupport(Context context) {
        if (context.getPackageManager() == null) {
            Logger.warn((String)TAG, (String)"getPackageManager() returned null.");
            return null;
        }
        Intent customTabServiceIntent = new Intent("android.support.customtabs.action.CustomTabsService");
        List resolveInfoList = context.getPackageManager().queryIntentServices(customTabServiceIntent, 0);
        if (resolveInfoList == null || resolveInfoList.isEmpty()) {
            Logger.warn((String)TAG, (String)"No Service responded to Intent: android.support.customtabs.action.CustomTabsService");
            return null;
        }
        for (ResolveInfo resolveInfo : resolveInfoList) {
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !CHROME_PACKAGE.equals(serviceInfo.packageName)) continue;
            return serviceInfo.packageName;
        }
        Logger.warn((String)TAG, (String)"No pkg with CustomTab support found.");
        return null;
    }

    public static String getChromePackage(Context context) {
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        String installedChromePackage = null;
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(CHROME_PACKAGE, 1);
            ApplicationInfo applicationInfo = packageInfo.applicationInfo;
            if (applicationInfo != null && applicationInfo.enabled) {
                installedChromePackage = CHROME_PACKAGE;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error((String)TAG, (String)"Failed to retrieve chrome package info.", (Throwable)e);
        }
        return installedChromePackage;
    }

    public static Map<String, String> decodeUrlToMap(String url, String delimiter) {
        HashMap<String, String> decodedUrlMap = new HashMap<String, String>();
        if (MsalUtils.isEmpty(url) || delimiter == null) {
            return decodedUrlMap;
        }
        StringTokenizer tokenizer = new StringTokenizer(url, delimiter);
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken();
            String[] elements = pair.split("=");
            if (elements.length != 2) continue;
            try {
                String key = MsalUtils.urlFormDecode(elements[0]);
                String value = MsalUtils.urlFormDecode(elements[1]);
                if (MsalUtils.isEmpty(key) || MsalUtils.isEmpty(value)) continue;
                decodedUrlMap.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                Logger.errorPII((String)TAG, (String)"URL form decode failed.", (Throwable)e);
            }
        }
        return decodedUrlMap;
    }

    public static String appendQueryParameterToUrl(String url, Map<String, String> requestParams) throws UnsupportedEncodingException {
        if (MsalUtils.isEmpty(url)) {
            throw new IllegalArgumentException("Empty authority string");
        }
        if (requestParams.isEmpty()) {
            return url;
        }
        HashSet<String> queryParamsSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            queryParamsSet.add(entry.getKey() + "=" + MsalUtils.urlFormEncode(entry.getValue()));
        }
        String queryString = StringUtil.convertSetToString(queryParamsSet, (String)QUERY_STRING_DELIMITER);
        String queryStringFormat = url.contains(QUERY_STRING_SYMBOL) ? (url.endsWith(QUERY_STRING_DELIMITER) ? "%s%s" : "%s&%s") : "%s?%s";
        return String.format(queryStringFormat, url, queryString);
    }

    public static String base64UrlEncodeToString(String message) {
        return Base64.encodeToString((byte[])message.getBytes(Charset.forName(ENCODING_UTF8)), (int)10);
    }

    public static boolean isScopeIntersects(Set<String> scopes, Set<String> otherScopes) {
        for (String scope : otherScopes) {
            if (!scopes.contains(scope)) continue;
            return true;
        }
        return false;
    }

    public static String createHash(String msg) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!MsalUtils.isEmpty(msg)) {
            MessageDigest digester = MessageDigest.getInstance(TOKEN_HASH_ALGORITHM);
            byte[] msgInBytes = msg.getBytes(ENCODING_UTF8);
            return new String(Base64.encode((byte[])digester.digest(msgInBytes), (int)2), ENCODING_UTF8);
        }
        return msg;
    }

    public static URL getUrl(String endpoint) {
        URL url = null;
        try {
            url = new URL(endpoint);
        }
        catch (MalformedURLException e1) {
            Logger.errorPII((String)TAG, (String)"Url is invalid", (Throwable)e1);
        }
        return url;
    }

    public static String getUniqueUserIdentifier(String uid, String utid) {
        return MsalUtils.base64UrlEncodeToString(uid) + "." + MsalUtils.base64UrlEncodeToString(utid);
    }

    public static long getExpiresOn(long expiresIn) {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSecs = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        return currentTimeSecs + expiresIn;
    }

    public static ApplicationInfo getApplicationInfo(Context context) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalStateException("Unable to find the package info, unable to proceed");
        }
        return applicationInfo;
    }

    public static Set<String> convertArrayToSet(String[] values) {
        HashSet<String> convertedSet = new HashSet<String>();
        if (values == null) {
            return convertedSet;
        }
        for (int i = 0; i < values.length; ++i) {
            if (MsalUtils.isEmpty(values[i])) continue;
            convertedSet.add(values[i]);
        }
        return convertedSet;
    }
}

