/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.claims;

import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.claims.ClaimsRequestDeserializer;
import com.microsoft.identity.client.claims.ClaimsRequestSerializer;
import com.microsoft.identity.client.claims.RequestClaimAdditionalInformationSerializer;
import com.microsoft.identity.client.claims.RequestedClaim;
import com.microsoft.identity.client.claims.RequestedClaimAdditionalInformation;
import java.util.ArrayList;
import java.util.List;

public class ClaimsRequest {
    public static final String USERINFO = "userinfo";
    public static final String ID_TOKEN = "id_token";
    public static final String ACCESS_TOKEN = "access_token";
    private List<RequestedClaim> mUserInfoClaimsRequested = new ArrayList<RequestedClaim>();
    private List<RequestedClaim> mAccessTokenClaimsRequested = new ArrayList<RequestedClaim>();
    private List<RequestedClaim> mIdTokenClaimsRequested = new ArrayList<RequestedClaim>();

    public List<RequestedClaim> getUserInfoClaimsRequested() {
        return this.mUserInfoClaimsRequested;
    }

    public List<RequestedClaim> getAccessTokenClaimsRequested() {
        return this.mAccessTokenClaimsRequested;
    }

    public List<RequestedClaim> getIdTokenClaimsRequested() {
        return this.mIdTokenClaimsRequested;
    }

    public static ClaimsRequest getClaimsRequestFromJsonString(String claimsRequestJson) {
        return ClaimsRequest.deserializeClaimsRequest(claimsRequestJson);
    }

    public static String getJsonStringFromClaimsRequest(@Nullable ClaimsRequest claimsRequest) {
        return ClaimsRequest.serializeClaimsRequest(claimsRequest);
    }

    private static String serializeClaimsRequest(@Nullable ClaimsRequest claimsRequest) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        ClaimsRequestSerializer claimsRequestSerializer = new ClaimsRequestSerializer();
        RequestClaimAdditionalInformationSerializer informationSerializer = new RequestClaimAdditionalInformationSerializer();
        gsonBuilder.registerTypeAdapter(ClaimsRequest.class, (Object)claimsRequestSerializer);
        gsonBuilder.registerTypeAdapter(RequestedClaimAdditionalInformation.class, (Object)informationSerializer);
        gsonBuilder.serializeNulls();
        Gson claimsRequestGson = gsonBuilder.create();
        String claimsRequestJson = claimsRequest != null ? claimsRequestGson.toJson((Object)claimsRequest) : null;
        return claimsRequestJson;
    }

    private static ClaimsRequest deserializeClaimsRequest(@Nullable String claimsRequestJson) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        ClaimsRequestDeserializer deserializer = new ClaimsRequestDeserializer();
        gsonBuilder.registerTypeAdapter(ClaimsRequest.class, (Object)deserializer);
        Gson claimsRequestGson = gsonBuilder.create();
        ClaimsRequest claimsRequest = (ClaimsRequest)claimsRequestGson.fromJson(claimsRequestJson, ClaimsRequest.class);
        return claimsRequest;
    }

    public void requestClaimInAccessToken(String name, RequestedClaimAdditionalInformation additionalInformation) {
        this.requestClaimIn(this.mAccessTokenClaimsRequested, name, additionalInformation);
    }

    public void requestClaimInIdToken(String name, RequestedClaimAdditionalInformation additionalInformation) {
        this.requestClaimIn(this.mIdTokenClaimsRequested, name, additionalInformation);
    }

    public void requestClaimInUserInfo(String name, RequestedClaimAdditionalInformation additionalInformation) {
        this.requestClaimIn(this.mUserInfoClaimsRequested, name, additionalInformation);
    }

    private void requestClaimIn(List<RequestedClaim> claims, String name, RequestedClaimAdditionalInformation additionalInformation) {
        RequestedClaim requestedClaim = new RequestedClaim();
        requestedClaim.setName(name);
        requestedClaim.setAdditionalInformation(additionalInformation);
        claims.add(requestedClaim);
    }
}

