/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import java.util.List;

abstract class TokenParameters {
    private List<String> mScopes;
    private IAccount mAccount;
    private String mAuthority;
    private ClaimsRequest mClaimsRequest;
    private AuthenticationCallback mCallback;
    private AccountRecord mAccountRecord;

    protected TokenParameters(Builder builder) {
        this.mAccount = builder.mAccount;
        this.mAuthority = builder.mAuthority;
        this.mCallback = builder.mCallback;
        this.mClaimsRequest = builder.mClaimsRequest;
        this.mScopes = builder.mScopes;
    }

    public List<String> getScopes() {
        return this.mScopes;
    }

    public void setScopes(List<String> scopes) {
        this.mScopes = scopes;
    }

    public IAccount getAccount() {
        return this.mAccount;
    }

    public void setAccount(IAccount account) {
        this.mAccount = account;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public ClaimsRequest getClaimsRequest() {
        return this.mClaimsRequest;
    }

    public void setClaimsRequest(ClaimsRequest claimsRequest) {
        this.mClaimsRequest = claimsRequest;
    }

    public AuthenticationCallback getCallback() {
        return this.mCallback;
    }

    public void setCallback(AuthenticationCallback callback) {
        this.mCallback = callback;
    }

    void setAccountRecord(AccountRecord record) {
        this.mAccountRecord = record;
    }

    public AccountRecord getAccountRecord() {
        return this.mAccountRecord;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private List<String> mScopes;
        private IAccount mAccount;
        private String mAuthority;
        private ClaimsRequest mClaimsRequest;
        private AuthenticationCallback mCallback;

        public B withScopes(List<String> scopes) {
            this.mScopes = scopes;
            return this.self();
        }

        public B forAccount(IAccount account) {
            this.mAccount = account;
            return this.self();
        }

        public B fromAuthority(String authority) {
            this.mAuthority = authority;
            return this.self();
        }

        public B withClaims(ClaimsRequest claimsRequest) {
            this.mClaimsRequest = claimsRequest;
            return this.self();
        }

        public B callback(AuthenticationCallback callback) {
            this.mCallback = callback;
            return this.self();
        }

        public abstract B self();

        public abstract TokenParameters build();
    }
}

