/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class AuthenticationResult
implements IAuthenticationResult {
    private final String mTenantId;
    private final String mRawIdToken;
    private final String mUniqueId;
    private final AccessTokenRecord mAccessToken;
    private final IAccount mAccount;

    public AuthenticationResult(@NonNull ICacheRecord cacheRecord) {
        this.mAccessToken = cacheRecord.getAccessToken();
        this.mTenantId = cacheRecord.getAccount().getRealm();
        this.mUniqueId = cacheRecord.getAccount().getHomeAccountId();
        this.mRawIdToken = cacheRecord.getIdToken().getSecret();
        this.mAccount = AccountAdapter.adapt((IAccountRecord)cacheRecord.getAccount());
    }

    public AuthenticationResult(@NonNull AccessTokenRecord accessToken, @Nullable String rawIdToken, @NonNull IAccountRecord accountRecord) {
        this.mAccessToken = accessToken;
        this.mTenantId = accessToken.getRealm();
        this.mUniqueId = accessToken.getHomeAccountId();
        this.mRawIdToken = rawIdToken;
        this.mAccount = AccountAdapter.adapt(accountRecord);
    }

    @Override
    @NonNull
    public String getAccessToken() {
        return this.mAccessToken.getSecret();
    }

    @Override
    @NonNull
    public Date getExpiresOn() {
        Date expiresOn = new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(this.mAccessToken.getExpiresOn())));
        return expiresOn;
    }

    @Override
    @Nullable
    public String getTenantId() {
        return this.mTenantId;
    }

    @Override
    @NonNull
    public String getUniqueId() {
        return this.mUniqueId;
    }

    @Override
    @Nullable
    public String getIdToken() {
        return this.mRawIdToken;
    }

    @Override
    @NonNull
    public IAccount getAccount() {
        return this.mAccount;
    }

    @Override
    @NonNull
    public String[] getScope() {
        return this.mAccessToken.getTarget().split("\\s");
    }
}

