/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.telemetry;

import android.util.Pair;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.telemetry.TelemetryUtils;
import java.util.ArrayList;

public class Event
extends ArrayList<Pair<String, String>> {
    public Event(Builder builder) {
        if (null == builder.mEventName) {
            throw new IllegalStateException("Event must have a name");
        }
        if (!"msal.default".equals(builder.mEventName)) {
            this.setProperty("msal.event_name", builder.mEventName);
        }
        if (null != builder.mEventStartTime) {
            this.setProperty("msal.start_time", String.valueOf(builder.mEventStartTime));
        }
        if (null != builder.mEventStartTime) {
            this.setProperty("msal.stop_time", String.valueOf(builder.mEventStopTime));
        }
        if (null != builder.mEventElapsedTime) {
            this.setProperty("msal.elapsed_time", String.valueOf(builder.mEventElapsedTime));
        }
    }

    public final void setProperty(String propertyName, String propertyValue) {
        if (!MsalUtils.isEmpty(propertyName) && !MsalUtils.isEmpty(propertyValue) && Event.isPrivacyCompliant(propertyName)) {
            this.add(new Pair((Object)propertyName, (Object)propertyValue));
        }
    }

    public final String getProperty(String propertyName) {
        String propertyValue = null;
        for (Pair property : this) {
            if (!((String)property.first).equals(propertyName)) continue;
            propertyValue = (String)property.second;
            break;
        }
        return propertyValue;
    }

    public int getPropertyCount() {
        return this.size();
    }

    public String getEventName() {
        return this.getProperty("msal.event_name");
    }

    public Long getStartTime() {
        return Long.valueOf(this.getProperty("msal.start_time"));
    }

    public Long getStopTime() {
        return Long.valueOf(this.getProperty("msal.stop_time"));
    }

    public Long getElapsedTime() {
        return Long.valueOf(this.getProperty("msal.elapsed_time"));
    }

    public static boolean isPrivacyCompliant(String fieldName) {
        return !TelemetryUtils.GDPR_FILTERED_FIELDS.contains(fieldName);
    }

    public static abstract class Builder<T extends Builder> {
        private final String mEventName;
        private Long mEventStartTime;
        private Long mEventStopTime;
        private Long mEventElapsedTime;
        private boolean mIsCompleted;

        public Builder(String name) {
            this.mEventName = name;
        }

        public final String getEventName() {
            return this.mEventName;
        }

        public final Long getStartTime() {
            return this.mEventStartTime;
        }

        public final boolean getIsCompleted() {
            return this.mIsCompleted;
        }

        public final T setStartTime(long startTime) {
            this.mEventStartTime = startTime;
            return (T)this;
        }

        public final T setStopTime(long stopTime) {
            this.mEventStopTime = stopTime;
            return (T)this;
        }

        public final T setElapsedTime(long elapsedTime) {
            this.mEventElapsedTime = elapsedTime;
            return (T)this;
        }

        public final T setIsCompleted(boolean isCompleted) {
            this.mIsCompleted = isCompleted;
            return (T)this;
        }

        public abstract Event build();
    }
}

