/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalUiRequiredException;
import com.microsoft.identity.client.internal.controllers.AcquireTokenResult;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenSilentOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALController;
import com.microsoft.identity.client.internal.controllers.MSALOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALTokenOperation;
import com.microsoft.identity.common.exception.ClientException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class MSALTokenCommand
implements MSALTokenOperation {
    protected MSALOperationParameters mParameters;
    protected MSALController mController;
    protected Context mContext;
    protected AuthenticationCallback mCallback;

    public MSALTokenCommand() {
    }

    public MSALTokenCommand(@NonNull Context context, @NonNull MSALOperationParameters parameters, @NonNull MSALController controller, @NonNull AuthenticationCallback callback) {
        this.mContext = context;
        this.mParameters = parameters;
        this.mController = controller;
        this.mCallback = callback;
        if (!(this.mParameters instanceof MSALAcquireTokenSilentOperationParameters)) {
            throw new IllegalArgumentException("Invalid operation parameters");
        }
    }

    @Override
    public AcquireTokenResult execute() throws InterruptedException, ExecutionException, IOException, ClientException, MsalClientException, MsalArgumentException, MsalUiRequiredException {
        return this.getController().acquireTokenSilent((MSALAcquireTokenSilentOperationParameters)this.getParameters());
    }

    @Override
    public void notify(int requestCode, int resultCode, Intent data) {
        throw new UnsupportedOperationException();
    }

    public MSALOperationParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(MSALOperationParameters parameters) {
        if (!(parameters instanceof MSALAcquireTokenSilentOperationParameters)) {
            throw new IllegalArgumentException("Invalid operation parameters");
        }
        this.mParameters = parameters;
    }

    public MSALController getController() {
        return this.mController;
    }

    public void setController(MSALController controller) {
        this.mController = controller;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public AuthenticationCallback getCallback() {
        return this.mCallback;
    }

    public void setCallback(AuthenticationCallback callback) {
        this.mCallback = callback;
    }
}

