/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.internal.authorities.Authority;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import java.util.ArrayList;
import java.util.Arrays;

public class MSALOperationParameters {
    private static final String TAG = MSALOperationParameters.class.getSimpleName();
    private Context mAppContext;
    private OAuth2TokenCache mTokenCache;
    private ArrayList<String> mScopes;
    protected IAccountRecord mAccount;
    private String clientId;
    private String redirectUri;
    private Authority mAuthority;

    public Context getAppContext() {
        return this.mAppContext;
    }

    public void setAppContext(Context mAppContext) {
        this.mAppContext = mAppContext;
    }

    public ArrayList<String> getScopes() {
        return this.mScopes;
    }

    public void setScopes(ArrayList<String> mScopes) {
        this.mScopes = mScopes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setTokenCache(OAuth2TokenCache cache) {
        this.mTokenCache = cache;
    }

    public OAuth2TokenCache getTokenCache() {
        return this.mTokenCache;
    }

    public Authority getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(Authority authority) {
        this.mAuthority = authority;
    }

    public void setAccount(IAccountRecord account) {
        this.mAccount = account;
    }

    public IAccountRecord getAccount() {
        return this.mAccount;
    }

    public void validate() throws MsalArgumentException {
        String methodName = ":validate";
        Logger.verbose((String)(TAG + ":validate"), (String)"Validating operation params...");
        Boolean validScopeArgument = false;
        if (this.mScopes != null) {
            this.mScopes.removeAll(Arrays.asList("", null));
            if (this.mScopes.size() > 0) {
                validScopeArgument = true;
            }
        }
        if (!validScopeArgument.booleanValue()) {
            if (this instanceof MSALAcquireTokenSilentOperationParameters) {
                throw new MsalArgumentException("acquireToken", "scopes", "scope is empty or null");
            }
            if (this instanceof MSALAcquireTokenOperationParameters) {
                throw new MsalArgumentException("acquireToken", "scopes", "scope is empty or null");
            }
        }
    }
}

