/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.authorities;

import android.net.Uri;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.internal.authorities.AllAccounts;
import com.microsoft.identity.client.internal.authorities.Authority;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectorySlice;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class AzureActiveDirectoryAuthority
extends Authority {
    private static final transient String TAG = AzureActiveDirectoryAuthority.class.getSimpleName();
    @SerializedName(value="audience")
    public AzureActiveDirectoryAudience mAudience;
    @SerializedName(value="slice")
    public AzureActiveDirectorySlice mSlice;
    @SerializedName(value="flight_parameters")
    public Map<String, String> mFlightParameters;
    private AzureActiveDirectoryCloud mAzureActiveDirectoryCloud;

    private void getAzureActiveDirectoryCloud() {
        String methodName = ":getAzureActiveDirectoryCloud";
        AzureActiveDirectoryCloud cloud = null;
        try {
            cloud = AzureActiveDirectory.getAzureActiveDirectoryCloud((URL)new URL(this.mAudience.getCloudUrl()));
            this.mKnownToMicrosoft = true;
        }
        catch (MalformedURLException e) {
            Logger.errorPII((String)(TAG + ":getAzureActiveDirectoryCloud"), (String)"AAD cloud URL was malformed.", (Throwable)e);
            cloud = null;
            this.mKnownToMicrosoft = false;
        }
        this.mAzureActiveDirectoryCloud = cloud;
    }

    public AzureActiveDirectoryAuthority(AzureActiveDirectoryAudience signInAudience) {
        this.mAudience = signInAudience;
        this.mAuthorityTypeString = "AAD";
        this.getAzureActiveDirectoryCloud();
    }

    public AzureActiveDirectoryAuthority() {
        this.mAudience = new AllAccounts();
        this.mAuthorityTypeString = "AAD";
        this.getAzureActiveDirectoryCloud();
    }

    public AzureActiveDirectorySlice getSlice() {
        return this.mSlice;
    }

    public Map<String, String> getFlightParameters() {
        return this.mFlightParameters;
    }

    @Override
    public Uri getAuthorityUri() {
        this.getAzureActiveDirectoryCloud();
        Uri issuer = this.mAzureActiveDirectoryCloud == null ? Uri.parse((String)this.mAudience.getCloudUrl()) : Uri.parse((String)("https://" + this.mAzureActiveDirectoryCloud.getPreferredNetworkHostName()));
        return issuer.buildUpon().appendPath(this.mAudience.getTenantId()).build();
    }

    @Override
    public URL getAuthorityURL() {
        try {
            return new URL(this.getAuthorityUri().toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Authority URL is not a URL.", e);
        }
    }

    @Override
    public OAuth2Strategy createOAuth2Strategy() {
        String methodName = ":createOAuth2Strategy";
        Logger.verbose((String)(TAG + ":createOAuth2Strategy"), (String)"Creating OAuth2Strategy");
        MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
        config.setAuthorityUrl(this.getAuthorityURL());
        if (this.mSlice != null) {
            Logger.info((String)(TAG + ":createOAuth2Strategy"), (String)"Setting slice parameters...");
            com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice slice = new com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice();
            slice.setSlice(this.mSlice.getSlice());
            slice.setDataCenter(this.mSlice.getDC());
            config.setSlice(slice);
        }
        if (this.mFlightParameters != null) {
            Logger.info((String)(TAG + ":createOAuth2Strategy"), (String)"Setting flight parameters...");
            for (Map.Entry<String, String> entry : this.mFlightParameters.entrySet()) {
                config.getFlightParameters().put(entry.getKey(), entry.getValue());
            }
        }
        return new MicrosoftStsOAuth2Strategy(config);
    }
}

