/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.internal.MsalUtils;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MsalChromeCustomTabManager {
    private static final String TAG = MsalChromeCustomTabManager.class.getSimpleName();
    private MsalCustomTabsServiceConnection mCustomTabsServiceConnection;
    private CustomTabsIntent mCustomTabsIntent;
    private String mChromePackageWithCustomTabSupport;
    private Activity mParentActivity;
    private static final long CUSTOM_TABS_MAX_CONNECTION_TIMEOUT = 1L;

    public MsalChromeCustomTabManager(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Activity parameter cannot be null");
        }
        this.mParentActivity = activity;
        this.mChromePackageWithCustomTabSupport = MsalUtils.getChromePackageWithCustomTabSupport(this.mParentActivity.getApplicationContext());
    }

    protected void verifyChromeTabOrBrowser() throws MsalClientException {
        if (this.mChromePackageWithCustomTabSupport == null) {
            Logger.warning(TAG, null, "Custom tab is not supported by Chrome.");
        } else if (MsalUtils.getChromePackage(this.mParentActivity.getApplicationContext()) == null) {
            Logger.warning(TAG, null, "Chrome is not installed.");
            throw new MsalClientException("chrome_not_installed", "Chrome is not installed.");
        }
    }

    public synchronized void bindCustomTabsService() {
        if (this.mChromePackageWithCustomTabSupport != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.mCustomTabsServiceConnection = new MsalCustomTabsServiceConnection(latch);
            CustomTabsClient.bindCustomTabsService((Context)this.mParentActivity, (String)this.mChromePackageWithCustomTabSupport, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection);
            boolean customTabsServiceConnected = this.waitForServiceConnectionToEstablish(latch);
            CustomTabsIntent.Builder builder = customTabsServiceConnected ? new CustomTabsIntent.Builder(this.mCustomTabsServiceConnection.getCustomTabsSession()) : new CustomTabsIntent.Builder();
            this.mCustomTabsIntent = builder.setShowTitle(true).build();
            this.mCustomTabsIntent.intent.setPackage(this.mChromePackageWithCustomTabSupport);
        }
    }

    private boolean waitForServiceConnectionToEstablish(CountDownLatch latch) {
        boolean connectionEstablished = true;
        try {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(1L, TimeUnit.SECONDS);
            if (timedOut) {
                connectionEstablished = false;
                Logger.warning(TAG, null, "Connection to CustomTabs timed out. Skipping warmup.");
            }
        }
        catch (InterruptedException e) {
            Logger.error(TAG, null, "Failed to connect to CustomTabs. Skipping warmup.", e);
            connectionEstablished = false;
        }
        return connectionEstablished;
    }

    public synchronized void unbindCustomTabsService() {
        if (null != this.mCustomTabsServiceConnection && this.mCustomTabsServiceConnection.getCustomTabsServiceIsBound()) {
            this.mParentActivity.unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
            this.mCustomTabsServiceConnection.unbindCustomTabsService();
        }
    }

    public void launchChromeTabOrBrowserForUrl(String requestUrl) {
        if (this.mChromePackageWithCustomTabSupport != null && this.mCustomTabsIntent != null) {
            Logger.info(TAG, null, "ChromeCustomTab support is available, launching chrome tab.");
            this.mCustomTabsIntent.launchUrl((Context)this.mParentActivity, Uri.parse((String)requestUrl));
        } else {
            Logger.info(TAG, null, "Chrome tab support is not available, launching chrome browser.");
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)requestUrl));
            browserIntent.setPackage(MsalUtils.getChromePackage(this.mParentActivity.getApplicationContext()));
            browserIntent.addCategory("android.intent.category.BROWSABLE");
            this.mParentActivity.startActivity(browserIntent);
        }
    }

    private static class MsalCustomTabsServiceConnection
    extends CustomTabsServiceConnection {
        private final WeakReference<CountDownLatch> mLatchWeakReference;
        private CustomTabsClient mCustomTabsClient;
        private CustomTabsSession mCustomTabsSession;
        private boolean mCustomTabsServiceIsBound;

        MsalCustomTabsServiceConnection(CountDownLatch latch) {
            this.mLatchWeakReference = new WeakReference<CountDownLatch>(latch);
        }

        public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
            CountDownLatch latch = (CountDownLatch)this.mLatchWeakReference.get();
            this.mCustomTabsServiceIsBound = true;
            this.mCustomTabsClient = client;
            this.mCustomTabsClient.warmup(0L);
            this.mCustomTabsSession = this.mCustomTabsClient.newSession(null);
            if (null != latch) {
                latch.countDown();
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            this.unbindCustomTabsService();
        }

        private void unbindCustomTabsService() {
            this.mCustomTabsClient = null;
            this.mCustomTabsServiceIsBound = false;
        }

        CustomTabsSession getCustomTabsSession() {
            return this.mCustomTabsSession;
        }

        boolean getCustomTabsServiceIsBound() {
            return this.mCustomTabsServiceIsBound;
        }
    }
}

