/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class AuthenticationResult {
    private final String mTenantId;
    private final String mRawIdToken;
    private final String mUniqueId;
    private final AccessTokenRecord mAccessToken;
    private final IAccount mAccount;

    public AuthenticationResult(ICacheRecord cacheRecord) {
        this.mAccessToken = cacheRecord.getAccessToken();
        this.mTenantId = cacheRecord.getAccount().getRealm();
        this.mUniqueId = cacheRecord.getAccount().getHomeAccountId();
        this.mRawIdToken = cacheRecord.getIdToken().getSecret();
        this.mAccount = AccountAdapter.adapt(cacheRecord.getAccount());
    }

    public String getAccessToken() {
        return this.mAccessToken.getSecret();
    }

    public Date getExpiresOn() {
        Date expiresOn = new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(this.mAccessToken.getExpiresOn())));
        return expiresOn;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    public String getIdToken() {
        return this.mRawIdToken;
    }

    public IAccount getAccount() {
        return this.mAccount;
    }

    public String[] getScope() {
        return this.mAccessToken.getTarget().split("\\s");
    }
}

