/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Intent;
import android.os.Handler;
import android.util.Pair;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.exception.MsalUserCancelException;
import com.microsoft.identity.client.internal.controllers.AcquireTokenResult;
import com.microsoft.identity.client.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenSilentOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALInteractiveTokenCommand;
import com.microsoft.identity.client.internal.controllers.MSALTokenCommand;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.IRequestContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MSALApiDispatcher {
    private static final String TAG = MSALApiDispatcher.class.getSimpleName();
    private static final ExecutorService sInteractiveExecutor = Executors.newSingleThreadExecutor();
    private static final ExecutorService sSilentExecutor = Executors.newCachedThreadPool();
    private static final Object sLock = new Object();
    private static MSALInteractiveTokenCommand sCommand = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final MSALInteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Logger.verbose((String)(TAG + ":beginInteractive"), (String)"Beginning interactive request");
        Object object = sLock;
        synchronized (object) {
            sInteractiveExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MSALApiDispatcher.initializeDiagnosticContext();
                    if (command.mParameters instanceof MSALAcquireTokenOperationParameters) {
                        MSALApiDispatcher.logInteractiveRequestParameters(":beginInteractive", (MSALAcquireTokenOperationParameters)command.mParameters);
                    }
                    sCommand = command;
                    AcquireTokenResult result = null;
                    MsalException msalException = null;
                    try {
                        result = command.execute();
                    }
                    catch (Exception e) {
                        Logger.errorPII((String)(TAG + ":beginInteractive"), (String)"Interactive request failed with Exception", (Throwable)e);
                        msalException = e instanceof MsalException ? (MsalException)e : ExceptionAdapter.msalExceptionFromException(e);
                    }
                    Handler handler = new Handler(command.getContext().getMainLooper());
                    if (msalException != null) {
                        final MsalException finalException = msalException;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onError(finalException);
                            }
                        });
                    } else if (null != result && result.getSucceeded().booleanValue()) {
                        final AuthenticationResult authenticationResult = result.getAuthenticationResult();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onSuccess(authenticationResult);
                            }
                        });
                    } else {
                        msalException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
                        final MsalException finalException = msalException;
                        if (finalException instanceof MsalUserCancelException) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onCancel();
                                }
                            });
                        } else {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onError(finalException);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private static void logInteractiveRequestParameters(String methodName, MSALAcquireTokenOperationParameters params) {
        Logger.verbose((String)(TAG + methodName), (String)("Requested " + params.getScopes().size() + " scopes"));
        Logger.verbosePII((String)(TAG + methodName), (String)"----\nRequested scopes:");
        for (String string : params.getScopes()) {
            Logger.verbosePII((String)(TAG + methodName), (String)("\t" + string));
        }
        Logger.verbosePII((String)(TAG + methodName), (String)"----");
        Logger.verbosePII((String)(TAG + methodName), (String)("ClientId: [" + params.getClientId() + "]"));
        Logger.verbosePII((String)(TAG + methodName), (String)("RedirectUri: [" + params.getRedirectUri() + "]"));
        Logger.verbosePII((String)(TAG + methodName), (String)("Login hint: [" + params.getLoginHint() + "]"));
        if (null != params.getExtraQueryStringParameters()) {
            Logger.verbosePII((String)(TAG + methodName), (String)"Extra query params:");
            for (Pair pair : params.getExtraQueryStringParameters()) {
                Logger.verbosePII((String)(TAG + methodName), (String)("\t\"" + (String)pair.first + "\":\"" + (String)pair.second + "\""));
            }
        }
        if (null != params.getExtraScopesToConsent()) {
            Logger.verbosePII((String)(TAG + methodName), (String)"Extra scopes to consent:");
            for (String string : params.getExtraScopesToConsent()) {
                Logger.verbosePII((String)(TAG + methodName), (String)("\t" + string));
            }
        }
        Logger.verbose((String)(TAG + methodName), (String)("Using authorization agent: " + params.getAuthorizationAgent().toString()));
        if (null != params.getAccount()) {
            Logger.verbosePII((String)(TAG + methodName), (String)("Using account: " + params.getAccount().getHomeAccountId()));
        }
    }

    private static void logSilentRequestParams(String methodName, MSALAcquireTokenSilentOperationParameters parameters) {
        Logger.verbosePII((String)(TAG + methodName), (String)("ClientId: [" + parameters.getClientId() + "]"));
        Logger.verbosePII((String)(TAG + methodName), (String)"----\nRequested scopes:");
        for (String scope : parameters.getScopes()) {
            Logger.verbosePII((String)(TAG + methodName), (String)("\t" + scope));
        }
        Logger.verbosePII((String)(TAG + methodName), (String)"----");
        if (null != parameters.getAccount()) {
            Logger.verbosePII((String)(TAG + methodName), (String)("Using account: " + parameters.getAccount().getHomeAccountId()));
        }
        Logger.verbose((String)(TAG + methodName), (String)("Force refresh? [" + parameters.getForceRefresh() + "]"));
    }

    public static void completeInteractive(int requestCode, int resultCode, Intent data) {
        sCommand.notify(requestCode, resultCode, data);
    }

    public static void submitSilent(final MSALTokenCommand command) {
        String methodName = ":submitSilent";
        Logger.verbose((String)(TAG + ":submitSilent"), (String)"Beginning silent request");
        sSilentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MSALApiDispatcher.initializeDiagnosticContext();
                if (command.mParameters instanceof MSALAcquireTokenSilentOperationParameters) {
                    MSALApiDispatcher.logSilentRequestParams(":submitSilent", (MSALAcquireTokenSilentOperationParameters)command.mParameters);
                }
                AcquireTokenResult result = null;
                MsalException msalException = null;
                try {
                    result = command.execute();
                }
                catch (Exception e) {
                    Logger.errorPII((String)(TAG + ":submitSilent"), (String)"Silent request failed with Exception", (Throwable)e);
                    msalException = e instanceof MsalException ? (MsalException)e : ExceptionAdapter.msalExceptionFromException(e);
                }
                Handler handler = new Handler(command.getContext().getMainLooper());
                if (msalException != null) {
                    final MsalException finalException = msalException;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onError(finalException);
                        }
                    });
                } else if (null != result && result.getSucceeded().booleanValue()) {
                    final AuthenticationResult authenticationResult = result.getAuthenticationResult();
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onSuccess(authenticationResult);
                        }
                    });
                } else {
                    msalException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
                    final MsalException finalException = msalException;
                    if (finalException instanceof MsalUserCancelException) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onCancel();
                            }
                        });
                    } else {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onError(finalException);
                            }
                        });
                    }
                }
            }
        });
    }

    public static String initializeDiagnosticContext() {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = UUID.randomUUID().toString();
        RequestContext rc = new RequestContext();
        rc.put((Object)"correlation_id", (Object)correlationId);
        DiagnosticContext.setRequestContext((IRequestContext)rc);
        Logger.verbose((String)(TAG + ":initializeDiagnosticContext"), (String)"Initialized new DiagnosticContext");
        return correlationId;
    }
}

