/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalUiRequiredException;
import com.microsoft.identity.client.internal.authorities.Authority;
import com.microsoft.identity.client.internal.controllers.AcquireTokenResult;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenSilentOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALController;
import com.microsoft.identity.client.internal.controllers.MSALOperationParameters;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.ui.AuthorizationStrategyFactory;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class LocalMSALController
extends MSALController {
    private static final String TAG = LocalMSALController.class.getSimpleName();
    private AuthorizationStrategy mAuthorizationStrategy = null;
    private AuthorizationRequest mAuthorizationRequest = null;

    @Override
    public AcquireTokenResult acquireToken(MSALAcquireTokenOperationParameters parameters) throws ExecutionException, InterruptedException, ClientException, IOException, MsalClientException, MsalArgumentException {
        String methodName = ":acquireToken";
        Logger.verbose((String)(TAG + ":acquireToken"), (String)"Acquiring token...");
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        parameters.validate();
        this.throwIfNetworkNotAvailable(parameters.getAppContext());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(parameters.getAuthority());
        if (!authorityResult.getKnown()) {
            throw authorityResult.getMsalClientException();
        }
        OAuth2Strategy oAuth2Strategy = parameters.getAuthority().createOAuth2Strategy();
        AuthorizationResult result = this.performAuthorizationRequest(oAuth2Strategy, parameters);
        acquireTokenResult.setAuthorizationResult(result);
        if (result.getAuthorizationStatus().equals((Object)AuthorizationStatus.SUCCESS)) {
            TokenResult tokenResult = this.performTokenRequest(oAuth2Strategy, this.mAuthorizationRequest, result.getAuthorizationResponse(), parameters);
            acquireTokenResult.setTokenResult(tokenResult);
            if (tokenResult != null && tokenResult.getSuccess()) {
                ICacheRecord cacheRecord = this.saveTokens(oAuth2Strategy, this.mAuthorizationRequest, tokenResult.getTokenResponse(), parameters.getTokenCache());
                acquireTokenResult.setAuthenticationResult(new AuthenticationResult(cacheRecord));
            }
        }
        return acquireTokenResult;
    }

    private AuthorizationResult performAuthorizationRequest(OAuth2Strategy strategy, MSALAcquireTokenOperationParameters parameters) throws ExecutionException, InterruptedException, MsalClientException {
        this.throwIfNetworkNotAvailable(parameters.getAppContext());
        this.mAuthorizationStrategy = AuthorizationStrategyFactory.getInstance().getAuthorizationStrategy(parameters.getActivity(), parameters.getAuthorizationAgent());
        this.mAuthorizationRequest = this.getAuthorizationRequest(strategy, parameters);
        Future future = strategy.requestAuthorization(this.mAuthorizationRequest, this.mAuthorizationStrategy);
        AuthorizationResult result = (AuthorizationResult)future.get();
        return result;
    }

    private AuthorizationRequest getAuthorizationRequest(OAuth2Strategy strategy, MSALOperationParameters parameters) {
        AuthorizationRequest.Builder builder = strategy.createAuthorizationRequestBuilder(parameters.getAccount());
        ArrayList<String> msalScopes = new ArrayList<String>();
        msalScopes.add("openid");
        msalScopes.add("profile");
        msalScopes.add("offline_access");
        msalScopes.addAll(parameters.getScopes());
        UUID correlationId = null;
        try {
            correlationId = UUID.fromString((String)DiagnosticContext.getRequestContext().get((Object)"correlation_id"));
        }
        catch (IllegalArgumentException ex) {
            Logger.error((String)"LocalMsalController", (String)"correlation id from diagnostic context is not a UUID", (Throwable)ex);
        }
        AuthorizationRequest.Builder request = builder.setClientId(parameters.getClientId()).setRedirectUri(parameters.getRedirectUri()).setCorrelationId(correlationId);
        if (parameters instanceof MSALAcquireTokenOperationParameters) {
            MSALAcquireTokenOperationParameters acquireTokenOperationParameters = (MSALAcquireTokenOperationParameters)parameters;
            msalScopes.addAll(acquireTokenOperationParameters.getExtraScopesToConsent());
            request.setLoginHint(acquireTokenOperationParameters.getLoginHint()).setExtraQueryParams(acquireTokenOperationParameters.getExtraQueryStringParameters()).setPrompt(acquireTokenOperationParameters.getUIBehavior().toString());
        }
        msalScopes.removeAll(Arrays.asList("", null));
        request.setScope(StringUtil.join((char)' ', msalScopes));
        return request.build();
    }

    private TokenResult performTokenRequest(OAuth2Strategy strategy, AuthorizationRequest request, AuthorizationResponse response, MSALAcquireTokenOperationParameters parameters) throws IOException, MsalClientException {
        this.throwIfNetworkNotAvailable(parameters.getAppContext());
        TokenRequest tokenRequest = strategy.createTokenRequest(request, response);
        tokenRequest.setGrantType("authorization_code");
        TokenResult tokenResult = null;
        tokenResult = strategy.requestToken(tokenRequest);
        return tokenResult;
    }

    void throwIfNetworkNotAvailable(Context context) throws MsalClientException {
        String methodName = ":throwIfNetworkNotAvailable";
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            throw new MsalClientException("device_network_not_available", "Device network connection is not available.");
        }
        Logger.info((String)(TAG + ":throwIfNetworkNotAvailable"), (String)"Network status: connected");
    }

    private ICacheRecord saveTokens(OAuth2Strategy strategy, AuthorizationRequest request, TokenResponse tokenResponse, OAuth2TokenCache tokenCache) throws ClientException {
        String methodName = ":saveTokens";
        Logger.verbose((String)(TAG + ":saveTokens"), (String)"Saving tokens...");
        return tokenCache.save(strategy, request, tokenResponse);
    }

    @Override
    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        String methodName = ":completeAcquireToken";
        Logger.verbose((String)(TAG + ":completeAcquireToken"), (String)"Completing acquire token...");
        this.mAuthorizationStrategy.completeAuthorization(requestCode, resultCode, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AcquireTokenResult acquireTokenSilent(MSALAcquireTokenSilentOperationParameters parameters) throws MsalClientException, IOException, ClientException, MsalArgumentException, MsalUiRequiredException {
        String methodName = ":acquireTokenSilent";
        Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Acquiring token silently...");
        ArrayList<String> msalScopes = new ArrayList<String>();
        msalScopes.add("openid");
        msalScopes.add("profile");
        msalScopes.add("offline_access");
        if (!parameters.getScopes().containsAll(msalScopes)) {
            parameters.getScopes().addAll(msalScopes);
            parameters.getScopes().removeAll(Arrays.asList("", null));
        }
        AcquireTokenResult acquireTokenSilentResult = new AcquireTokenResult();
        parameters.validate();
        OAuth2TokenCache tokenCache = parameters.getTokenCache();
        String clientId = parameters.getClientId();
        String homeAccountId = parameters.getAccount().getHomeAccountId();
        AccountRecord targetAccount = tokenCache.getAccount(null, clientId, homeAccountId);
        if (null == targetAccount) {
            Logger.errorPII((String)TAG, (String)("No accounts found for clientId, homeAccountId: [" + clientId + ", " + homeAccountId + "]"), null);
            throw new MsalClientException("no_account_found", "No cached accounts found for the supplied homeAccountId");
        }
        OAuth2Strategy strategy = parameters.getAuthority().createOAuth2Strategy();
        ICacheRecord cacheRecord = tokenCache.load(clientId, TextUtils.join((CharSequence)" ", parameters.getScopes()), targetAccount);
        if (this.accessTokenIsNull(cacheRecord) || this.refreshTokenIsNull(cacheRecord) || parameters.getForceRefresh()) {
            if (this.refreshTokenIsNull(cacheRecord)) throw new MsalClientException("no_tokens_found", "No refresh token was found. ");
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"No access token found, but RT is available.");
            this.renewAccessToken(parameters, acquireTokenSilentResult, tokenCache, strategy, cacheRecord);
            return acquireTokenSilentResult;
        } else if (cacheRecord.getAccessToken().isExpired()) {
            Logger.warn((String)(TAG + ":acquireTokenSilent"), (String)"Access token is expired. Removing from cache...");
            tokenCache.removeCredential((Credential)cacheRecord.getAccessToken());
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Renewing access token...");
            this.renewAccessToken(parameters, acquireTokenSilentResult, tokenCache, strategy, cacheRecord);
            return acquireTokenSilentResult;
        } else {
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Returning silent result");
            acquireTokenSilentResult.setAuthenticationResult(new AuthenticationResult(cacheRecord));
        }
        return acquireTokenSilentResult;
    }

    private void renewAccessToken(@NonNull MSALAcquireTokenSilentOperationParameters parameters, @NonNull AcquireTokenResult acquireTokenSilentResult, @NonNull OAuth2TokenCache tokenCache, @NonNull OAuth2Strategy strategy, @NonNull ICacheRecord cacheRecord) throws MsalClientException, IOException, ClientException, MsalUiRequiredException {
        String methodName = ":renewAccessToken";
        Logger.verbose((String)(TAG + ":renewAccessToken"), (String)"Renewing access token...");
        parameters.setRefreshToken(cacheRecord.getRefreshToken());
        TokenResult tokenResult = this.performSilentTokenRequest(strategy, parameters);
        acquireTokenSilentResult.setTokenResult(tokenResult);
        if (tokenResult.getSuccess()) {
            Logger.verbose((String)(TAG + ":renewAccessToken"), (String)"Token request was successful");
            ICacheRecord savedRecord = tokenCache.save(strategy, this.getAuthorizationRequest(strategy, parameters), tokenResult.getTokenResponse());
            AuthenticationResult authenticationResult = new AuthenticationResult(savedRecord);
            acquireTokenSilentResult.setAuthenticationResult(authenticationResult);
        } else if (null != tokenResult.getErrorResponse()) {
            if (null != tokenResult.getErrorResponse().getError()) {
                Logger.warn((String)TAG, (String)tokenResult.getErrorResponse().getError());
            }
            if (null != tokenResult.getErrorResponse().getErrorDescription()) {
                Logger.warnPII((String)TAG, (String)tokenResult.getErrorResponse().getErrorDescription());
            }
            if ("invalid_grant".equalsIgnoreCase(tokenResult.getErrorResponse().getError())) {
                throw new MsalUiRequiredException("invalid_grant", null != tokenResult.getErrorResponse().getErrorDescription() ? tokenResult.getErrorResponse().getErrorDescription() : "Failed to renew access token");
            }
        }
    }

    private boolean refreshTokenIsNull(ICacheRecord cacheRecord) {
        return null == cacheRecord.getRefreshToken();
    }

    private boolean accessTokenIsNull(ICacheRecord cacheRecord) {
        return null == cacheRecord.getAccessToken();
    }

    private TokenResult performSilentTokenRequest(OAuth2Strategy strategy, MSALAcquireTokenSilentOperationParameters parameters) throws MsalClientException, IOException {
        String methodName = ":performSilentTokenRequest";
        Logger.verbose((String)(TAG + ":performSilentTokenRequest"), (String)"Requesting tokens...");
        this.throwIfNetworkNotAvailable(parameters.getAppContext());
        TokenRequest refreshTokenRequest = strategy.createRefreshTokenRequest();
        refreshTokenRequest.setClientId(parameters.getClientId());
        refreshTokenRequest.setScope(StringUtil.join((char)' ', parameters.getScopes()));
        refreshTokenRequest.setRefreshToken(parameters.getRefreshToken().getSecret());
        refreshTokenRequest.setRedirectUri(parameters.getRedirectUri());
        if (!StringExtensions.isNullOrBlank((String)refreshTokenRequest.getScope())) {
            Logger.verbosePII((String)(TAG + ":performSilentTokenRequest"), (String)("Scopes: [" + refreshTokenRequest.getScope() + "]"));
        }
        return strategy.requestToken(refreshTokenRequest);
    }
}

