/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.configuration;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.microsoft.identity.client.internal.authorities.ActiveDirectoryFederationServicesAuthority;
import com.microsoft.identity.client.internal.authorities.Authority;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.client.internal.authorities.UnknownAuthority;
import com.microsoft.identity.common.internal.logging.Logger;
import java.lang.reflect.Type;

public class AuthorityDeserializer
implements JsonDeserializer<Authority> {
    private static final String TAG = AuthorityDeserializer.class.getSimpleName();

    public Authority deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String methodName = ":deserialize";
        JsonObject authorityObject = json.getAsJsonObject();
        JsonElement type = authorityObject.get("type");
        if (type != null) {
            switch (type.getAsString()) {
                case "AAD": {
                    Logger.verbose((String)(TAG + ":deserialize"), (String)"Type: AAD");
                    return (Authority)context.deserialize((JsonElement)authorityObject, AzureActiveDirectoryAuthority.class);
                }
                case "B2C": {
                    Logger.verbose((String)(TAG + ":deserialize"), (String)"Type: B2C");
                    return (Authority)context.deserialize((JsonElement)authorityObject, AzureActiveDirectoryB2CAuthority.class);
                }
                case "ADFS": {
                    Logger.verbose((String)(TAG + ":deserialize"), (String)"Type: ADFS");
                    return (Authority)context.deserialize((JsonElement)authorityObject, ActiveDirectoryFederationServicesAuthority.class);
                }
            }
            Logger.verbose((String)(TAG + ":deserialize"), (String)"Type: Unknown");
            return (Authority)context.deserialize((JsonElement)authorityObject, UnknownAuthority.class);
        }
        return null;
    }
}

