/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Pair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.BrowserTabActivity;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.UiBehavior;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.authorities.Authority;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.client.internal.configuration.AuthorityDeserializer;
import com.microsoft.identity.client.internal.configuration.AzureActiveDirectoryAudienceDeserializer;
import com.microsoft.identity.client.internal.configuration.LogLevelDeserializer;
import com.microsoft.identity.client.internal.controllers.LocalMSALController;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenSilentOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALApiDispatcher;
import com.microsoft.identity.client.internal.controllers.MSALInteractiveTokenCommand;
import com.microsoft.identity.client.internal.controllers.MSALTokenCommand;
import com.microsoft.identity.client.internal.telemetry.DefaultEvent;
import com.microsoft.identity.client.internal.telemetry.Defaults;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.internal.cache.AccountCredentialCache;
import com.microsoft.identity.common.internal.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.cache.MicrosoftStsAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.msal.R;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PublicClientApplication {
    private static final String TAG = PublicClientApplication.class.getSimpleName();
    private static final String CLIENT_ID_META_DATA = "com.microsoft.identity.client.ClientId";
    private static final String AUTHORITY_META_DATA = "com.microsoft.identity.client.AuthorityMetadata";
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static final String ACCESS_NETWORK_STATE_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";
    private static final String DEFAULT_AUTHORITY = "https://login.microsoftonline.com/common/";
    private final Context mAppContext;
    private final OAuth2TokenCache mOauth2TokenCache;
    private String mAuthorityString;
    private String mClientId;
    private String mRedirectUri;
    private PublicClientApplicationConfiguration mPublicClientConfiguration;

    @Deprecated
    public PublicClientApplication(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null.");
        }
        this.mAppContext = context;
        this.mOauth2TokenCache = this.getOAuth2TokenCache();
        this.setupConfiguration();
        this.loadMetaDataFromManifest();
        this.initializeApplication();
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    public PublicClientApplication(@NonNull Context context, int configFileResourceId) {
        if (context == null) {
            throw new IllegalArgumentException("context is null.");
        }
        this.mAppContext = context;
        this.mOauth2TokenCache = this.getOAuth2TokenCache();
        this.setupConfiguration(configFileResourceId);
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    public PublicClientApplication(@NonNull Context context, @NonNull String clientId) {
        if (context == null) {
            throw new IllegalArgumentException("Context is null");
        }
        if (MsalUtils.isEmpty(clientId)) {
            throw new IllegalArgumentException("client id is empty or null");
        }
        this.mAppContext = context;
        this.mOauth2TokenCache = this.getOAuth2TokenCache();
        this.mClientId = clientId;
        this.setupConfiguration();
        this.initializeApplication();
        this.mAuthorityString = DEFAULT_AUTHORITY;
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    public PublicClientApplication(@NonNull Context context, @NonNull String clientId, @NonNull String authority) {
        this(context, clientId);
        if (MsalUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("authority is empty or null");
        }
        this.mAuthorityString = authority;
        this.mPublicClientConfiguration.getAuthorities().clear();
        this.mPublicClientConfiguration.getAuthorities().add(Authority.getAuthorityFromAuthorityUrl(authority));
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
    }

    private void initializeApplication() {
        DefaultEvent.initializeDefaults(Defaults.forApplication(this.mAppContext, this.mClientId));
        this.mRedirectUri = this.createRedirectUri(this.mClientId);
        this.checkIntentFilterAddedToAppManifest();
        this.checkInternetPermission();
        Logger.info((String)TAG, (String)"Create new public client application.");
    }

    public static String getSdkVersion() {
        return "0.2.1";
    }

    public PublicClientApplicationConfiguration getConfiguration() {
        return this.mPublicClientConfiguration;
    }

    public List<IAccount> getAccounts() {
        MSALApiDispatcher.initializeDiagnosticContext();
        ArrayList<IAccount> accountsToReturn = new ArrayList<IAccount>();
        List accountsInCache = this.mOauth2TokenCache.getAccounts(null, this.mClientId);
        for (AccountRecord account : accountsInCache) {
            accountsToReturn.add(AccountAdapter.adapt(account));
        }
        return Collections.unmodifiableList(accountsToReturn);
    }

    public IAccount getAccount(String homeAccountIdentifier) {
        MSALApiDispatcher.initializeDiagnosticContext();
        AccountRecord accountToReturn = this.getAccountInternal(homeAccountIdentifier);
        return null == accountToReturn ? null : AccountAdapter.adapt(accountToReturn);
    }

    private AccountRecord getAccountInternal(String homeAccountIdentifier) {
        AccountRecord accountToReturn;
        if (!StringUtil.isEmpty((String)homeAccountIdentifier)) {
            accountToReturn = this.mOauth2TokenCache.getAccount(null, this.mClientId, homeAccountIdentifier);
        } else {
            Logger.warn((String)TAG, (String)"homeAccountIdentifier was null or empty -- invalid criteria");
            accountToReturn = null;
        }
        return accountToReturn;
    }

    public boolean removeAccount(IAccount account) {
        MSALApiDispatcher.initializeDiagnosticContext();
        if (null == account || null == account.getHomeAccountIdentifier() || StringUtil.isEmpty((String)account.getHomeAccountIdentifier().getIdentifier())) {
            Logger.warn((String)TAG, (String)"Requisite IAccount or IAccount fields were null. Insufficient criteria to remove IAccount.");
            return false;
        }
        return this.mOauth2TokenCache.removeAccount(account.getEnvironment(), this.mClientId, account.getHomeAccountIdentifier().getIdentifier());
    }

    public void handleInteractiveRequestRedirect(int requestCode, int resultCode, Intent data) {
        MSALApiDispatcher.completeInteractive(requestCode, resultCode, data);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        MSALAcquireTokenOperationParameters params = this.getInteractiveOperationParameters(activity, scopes, null, UiBehavior.SELECT_ACCOUNT, null, null, null, null);
        MSALInteractiveTokenCommand command = new MSALInteractiveTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.beginInteractive(command);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable String loginHint, @NonNull AuthenticationCallback callback) {
        MSALAcquireTokenOperationParameters params = this.getInteractiveOperationParameters(activity, scopes, loginHint, UiBehavior.SELECT_ACCOUNT, null, null, null, null);
        MSALInteractiveTokenCommand command = new MSALInteractiveTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.beginInteractive(command);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable String loginHint, @NonNull UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @NonNull AuthenticationCallback callback) {
        MSALAcquireTokenOperationParameters params = this.getInteractiveOperationParameters(activity, scopes, loginHint, uiBehavior, extraQueryParameters, null, null, null);
        MSALInteractiveTokenCommand command = new MSALInteractiveTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.beginInteractive(command);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable IAccount account, @NonNull UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @NonNull AuthenticationCallback callback) {
        String loginHint = null;
        String authority = null;
        if (null != account) {
            loginHint = account.getUsername();
            authority = account.getEnvironment();
        }
        MSALAcquireTokenOperationParameters params = this.getInteractiveOperationParameters(activity, scopes, loginHint, uiBehavior, extraQueryParameters, null, authority, account);
        MSALInteractiveTokenCommand command = new MSALInteractiveTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.beginInteractive(command);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, String loginHint, UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, String[] extraScopesToConsent, String authority, @NonNull AuthenticationCallback callback) {
        MSALAcquireTokenOperationParameters params = this.getInteractiveOperationParameters(activity, scopes, loginHint, uiBehavior, extraQueryParameters, extraScopesToConsent, authority, null);
        MSALInteractiveTokenCommand command = new MSALInteractiveTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.beginInteractive(command);
    }

    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable IAccount account, @NonNull UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @NonNull AuthenticationCallback callback) {
        String loginHint = null;
        if (null != account) {
            loginHint = account.getUsername();
        }
        MSALAcquireTokenOperationParameters params = this.getInteractiveOperationParameters(activity, scopes, loginHint, uiBehavior, extraQueryParameters, extraScopesToConsent, authority, account);
        MSALInteractiveTokenCommand command = new MSALInteractiveTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.beginInteractive(command);
    }

    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull IAccount account, @NonNull AuthenticationCallback callback) {
        String requestAuthority = Authority.getAuthorityFromAccount(account);
        if (null == requestAuthority) {
            requestAuthority = this.mAuthorityString;
        }
        MSALAcquireTokenSilentOperationParameters params = this.getSilentOperationParameters(scopes, requestAuthority, false, account);
        MSALTokenCommand silentTokenCommand = new MSALTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.submitSilent(silentTokenCommand);
    }

    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull IAccount account, @Nullable String authority, boolean forceRefresh, @NonNull AuthenticationCallback callback) {
        String requestAuthority = authority;
        if (StringUtil.isEmpty((String)requestAuthority) && (requestAuthority = this.getSilentRequestAuthority(account)) == null) {
            requestAuthority = this.mAuthorityString;
        }
        MSALAcquireTokenSilentOperationParameters params = this.getSilentOperationParameters(scopes, requestAuthority, forceRefresh, account);
        MSALTokenCommand silentTokenCommand = new MSALTokenCommand(this.mAppContext, params, new LocalMSALController(), callback);
        MSALApiDispatcher.submitSilent(silentTokenCommand);
    }

    private String getSilentRequestAuthority(IAccount account) {
        String requestAuthority = null;
        try {
            if (!StringUtil.isEmpty((String)this.mAuthorityString) && Authority.getAuthorityFromAuthorityUrl(this.mAuthorityString) instanceof AzureActiveDirectoryB2CAuthority) {
                requestAuthority = this.mAuthorityString;
            }
        }
        catch (IllegalArgumentException exc) {
            Logger.warn((String)TAG, (String)exc.getMessage());
        }
        if (requestAuthority == null) {
            requestAuthority = Authority.getAuthorityFromAccount(account);
        }
        return requestAuthority;
    }

    private MSALAcquireTokenSilentOperationParameters getSilentOperationParameters(String[] scopes, String authorityStr, boolean forceRefresh, IAccount account) {
        MSALAcquireTokenSilentOperationParameters parameters = new MSALAcquireTokenSilentOperationParameters();
        parameters.setAppContext(this.mAppContext);
        parameters.setScopes(new ArrayList<String>(Arrays.asList(scopes)));
        parameters.setClientId(this.mClientId);
        parameters.setTokenCache(this.mOauth2TokenCache);
        parameters.setAuthority(Authority.getAuthorityFromAuthorityUrl(authorityStr));
        parameters.setRedirectUri(this.mRedirectUri);
        if (null != account) {
            parameters.setAccount((IAccountRecord)this.getAccountInternal(account.getHomeAccountIdentifier().getIdentifier()));
        }
        parameters.setForceRefresh(forceRefresh);
        return parameters;
    }

    private void loadMetaDataFromManifest() {
        String methodName = ":loadMetaDataFromManifest";
        Logger.verbose((String)(TAG + ":loadMetaDataFromManifest"), (String)"Loading metadata from manifest...");
        ApplicationInfo applicationInfo = MsalUtils.getApplicationInfo(this.mAppContext);
        if (applicationInfo == null || applicationInfo.metaData == null) {
            throw new IllegalArgumentException("No meta-data exists");
        }
        String authority = applicationInfo.metaData.getString(AUTHORITY_META_DATA);
        if (!MsalUtils.isEmpty(authority)) {
            this.mAuthorityString = authority;
            this.mPublicClientConfiguration.getAuthorities().clear();
            this.mPublicClientConfiguration.getAuthorities().add(Authority.getAuthorityFromAuthorityUrl(this.mAuthorityString));
        } else {
            this.mAuthorityString = DEFAULT_AUTHORITY;
        }
        String clientId = applicationInfo.metaData.getString(CLIENT_ID_META_DATA);
        if (MsalUtils.isEmpty(clientId)) {
            throw new IllegalArgumentException("client id missing from manifest");
        }
        this.mClientId = clientId;
        this.mPublicClientConfiguration.mClientId = clientId;
    }

    private void setupConfiguration(int configResourceId) {
        PublicClientApplicationConfiguration developerConfig = PublicClientApplication.loadConfiguration(this.mAppContext, configResourceId);
        PublicClientApplicationConfiguration defaultConfig = this.loadDefaultConfiguration(this.mAppContext);
        defaultConfig.mergeConfiguration(developerConfig);
        this.mPublicClientConfiguration = defaultConfig;
        if (!StringUtil.isEmpty((String)this.mPublicClientConfiguration.getClientId())) {
            this.mClientId = this.mPublicClientConfiguration.getClientId();
        }
        if (!StringUtil.isEmpty((String)this.mPublicClientConfiguration.getRedirectUri())) {
            this.mRedirectUri = this.mPublicClientConfiguration.getRedirectUri();
        }
        this.mAuthorityString = this.mPublicClientConfiguration.isDefaultAuthorityConfigured() ? this.mPublicClientConfiguration.getDefaultAuthority().getAuthorityURL().toString() : DEFAULT_AUTHORITY;
    }

    private void setupConfiguration() {
        this.mPublicClientConfiguration = this.loadDefaultConfiguration(this.mAppContext);
    }

    @VisibleForTesting
    static PublicClientApplicationConfiguration loadConfiguration(@NonNull Context context, int configResourceId) {
        byte[] buffer;
        InputStream configStream = context.getResources().openRawResource(configResourceId);
        try {
            buffer = new byte[configStream.available()];
            configStream.read(buffer);
        }
        catch (IOException e) {
            if (configResourceId == R.raw.msal_default_config) {
                throw new IllegalStateException("Unable to open default configuration file.  MSAL module may be incomplete.");
            }
            throw new IllegalArgumentException("Provided config file resource id could not be accessed");
        }
        String config = new String(buffer);
        Gson gson = PublicClientApplication.getGsonForLoadingConfiguration();
        return (PublicClientApplicationConfiguration)gson.fromJson(config, PublicClientApplicationConfiguration.class);
    }

    private PublicClientApplicationConfiguration loadDefaultConfiguration(@NonNull Context context) {
        String methodName = ":loadDefaultConfiguration";
        Logger.verbose((String)(TAG + ":loadDefaultConfiguration"), (String)"Loading default configuration");
        return PublicClientApplication.loadConfiguration(context, R.raw.msal_default_config);
    }

    private static Gson getGsonForLoadingConfiguration() {
        return new GsonBuilder().registerTypeAdapter(Authority.class, (Object)new AuthorityDeserializer()).registerTypeAdapter(AzureActiveDirectoryAudience.class, (Object)new AzureActiveDirectoryAudienceDeserializer()).registerTypeAdapter(Logger.LogLevel.class, (Object)new LogLevelDeserializer()).create();
    }

    private void checkIntentFilterAddedToAppManifest() {
        if (!MsalUtils.hasCustomTabRedirectActivity(this.mAppContext, this.mRedirectUri)) {
            throw new IllegalStateException("Intent filter for: " + BrowserTabActivity.class.getSimpleName() + " is missing.  Please refer to the MSAL readme.");
        }
    }

    private void checkInternetPermission() {
        PackageManager packageManager = this.mAppContext.getPackageManager();
        if (packageManager.checkPermission(INTERNET_PERMISSION, this.mAppContext.getPackageName()) != 0 || packageManager.checkPermission(ACCESS_NETWORK_STATE_PERMISSION, this.mAppContext.getPackageName()) != 0) {
            throw new IllegalStateException("android.permission.Internet or android.permission.ACCESS_NETWORK_STATE is missing");
        }
    }

    private String createRedirectUri(String clientId) {
        String methodName = ":createRedirectUri";
        if (!StringUtil.isEmpty((String)this.mPublicClientConfiguration.getRedirectUri())) {
            Logger.verbose((String)(TAG + ":createRedirectUri"), (String)"Returning redirectUri from configuration");
            return this.mPublicClientConfiguration.getRedirectUri();
        }
        return "msal" + clientId + "://auth";
    }

    private MSALAcquireTokenOperationParameters getInteractiveOperationParameters(@NonNull Activity activity, @NonNull String[] scopes, @Nullable String loginHint, UiBehavior uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @Nullable IAccount account) {
        String methodName = ":getInteractiveOperationParameters";
        MSALAcquireTokenOperationParameters params = new MSALAcquireTokenOperationParameters();
        if (StringUtil.isEmpty((String)authority)) {
            if (this.mPublicClientConfiguration.isDefaultAuthorityConfigured()) {
                Logger.verbose((String)(TAG + ":getInteractiveOperationParameters"), (String)"Using default configured authority");
                params.setAuthority(this.mPublicClientConfiguration.getDefaultAuthority());
            } else {
                params.setAuthority(Authority.getAuthorityFromAuthorityUrl(this.mAuthorityString));
            }
        } else {
            params.setAuthority(Authority.getAuthorityFromAuthorityUrl(authority));
        }
        Logger.verbosePII((String)(TAG + ":getInteractiveOperationParameters"), (String)("Using authority: [" + params.getAuthority().getAuthorityUri() + "]"));
        params.setScopes(new ArrayList<String>(Arrays.asList(scopes)));
        params.setClientId(this.mClientId);
        params.setRedirectUri(this.mRedirectUri);
        params.setActivity(activity);
        params.setLoginHint(loginHint);
        params.setTokenCache(this.mOauth2TokenCache);
        params.setExtraQueryStringParameters(extraQueryParameters);
        params.setExtraScopesToConsent(null != extraScopesToConsent ? Arrays.asList(extraScopesToConsent) : new ArrayList<String>());
        params.setAppContext(this.mAppContext);
        if (null != this.mPublicClientConfiguration.getAuthorizationAgent()) {
            params.setAuthorizationAgent(this.mPublicClientConfiguration.getAuthorizationAgent());
        } else {
            params.setAuthorizationAgent(AuthorizationAgent.DEFAULT);
        }
        if (uiBehavior == null) {
            params.setUIBehavior(UiBehavior.SELECT_ACCOUNT);
        } else {
            params.setUIBehavior(uiBehavior);
        }
        params.setAppContext(this.mAppContext);
        if (null != account) {
            params.setAccount((IAccountRecord)this.getAccountInternal(account.getHomeAccountIdentifier().getIdentifier()));
        }
        return params;
    }

    private MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> initCommonCache(Context context) {
        String methodName = ":initCommonCache";
        Logger.verbose((String)(TAG + ":initCommonCache"), (String)"Initializing common cache");
        CacheKeyValueDelegate cacheKeyValueDelegate = new CacheKeyValueDelegate();
        StorageHelper storageHelper = new StorageHelper(context);
        SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(context, "com.microsoft.identity.client.account_credential_cache", (IStorageHelper)storageHelper);
        AccountCredentialCache accountCredentialCache = new AccountCredentialCache((ICacheKeyValueDelegate)cacheKeyValueDelegate, (ISharedPreferencesFileManager)sharedPreferencesFileManager);
        MicrosoftStsAccountCredentialAdapter accountCredentialAdapter = new MicrosoftStsAccountCredentialAdapter();
        return new MsalOAuth2TokenCache(context, (IAccountCredentialCache)accountCredentialCache, (IAccountCredentialAdapter)accountCredentialAdapter);
    }

    private OAuth2TokenCache<?, ?, ?> getOAuth2TokenCache() {
        return this.initCommonCache(this.mAppContext);
    }
}

