/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.Telemetry;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.telemetry.UiEvent;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class AuthenticationActivity
extends Activity {
    private static final String TAG = AuthenticationActivity.class.getSimpleName();
    private static final long CUSTOMTABS_MAX_CONNECTION_TIMEOUT = 1L;
    private String mRequestUrl;
    private int mRequestId;
    private boolean mRestarted;
    private String mChromePackageWithCustomTabSupport;
    private CustomTabsIntent mCustomTabsIntent;
    private MsalCustomTabsServiceConnection mCustomTabsServiceConnection;
    private UiEvent.Builder mUiEventBuilder;
    private String mTelemetryRequestId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mChromePackageWithCustomTabSupport = MsalUtils.getChromePackageWithCustomTabSupport(this.getApplicationContext());
        if (savedInstanceState != null) {
            Logger.verbose(TAG, null, "AuthenticationActivity is re-created after killed by the os.");
            this.mRestarted = true;
            this.mTelemetryRequestId = savedInstanceState.getString("com.microsoft.identity.telemetry.request.id");
            this.mUiEventBuilder = new UiEvent.Builder();
            return;
        }
        Intent data = this.getIntent();
        if (data == null) {
            this.sendError("unresolvable_intent", "Received null data intent from caller");
            return;
        }
        this.mRequestUrl = data.getStringExtra("com.microsoft.identity.request.url.key");
        this.mRequestId = data.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
        if (MsalUtils.isEmpty(this.mRequestUrl)) {
            this.sendError("unresolvable_intent", "Request url is not set on the intent");
            return;
        }
        if (MsalUtils.getChromePackage(this.getApplicationContext()) == null) {
            Logger.info(TAG, null, "Chrome is not installed on the device, cannot continue with auth.");
            this.sendError("chrome_not_installed", "Chrome is not installed on the device, cannot proceed with auth");
            return;
        }
        this.mTelemetryRequestId = data.getStringExtra("com.microsoft.identity.telemetry.request.id");
        this.mUiEventBuilder = new UiEvent.Builder();
        Telemetry.getInstance().startEvent(this.mTelemetryRequestId, this.mUiEventBuilder);
    }

    protected void onStart() {
        super.onStart();
        if (this.mChromePackageWithCustomTabSupport != null) {
            this.warmUpCustomTabs();
        }
    }

    protected void onStop() {
        super.onStop();
        if (null != this.mCustomTabsServiceConnection && this.mCustomTabsServiceConnection.getCustomTabsServiceIsBound()) {
            this.unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
        }
    }

    private void warmUpCustomTabs() {
        CountDownLatch latch = new CountDownLatch(1);
        this.mCustomTabsServiceConnection = new MsalCustomTabsServiceConnection(latch);
        CustomTabsClient.bindCustomTabsService((Context)this, (String)this.mChromePackageWithCustomTabSupport, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection);
        boolean initCustomTabsWithSession = true;
        try {
            boolean timedOut;
            boolean bl = timedOut = !latch.await(1L, TimeUnit.SECONDS);
            if (timedOut) {
                initCustomTabsWithSession = false;
                Logger.warning(TAG, null, "Connection to CustomTabs timed out. Skipping warmup.");
            }
        }
        catch (InterruptedException e) {
            Logger.error(TAG, null, "Failed to connect to CustomTabs. Skipping warmup.", e);
            initCustomTabsWithSession = false;
        }
        CustomTabsIntent.Builder builder = initCustomTabsWithSession ? new CustomTabsIntent.Builder(this.mCustomTabsServiceConnection.getCustomTabsSession()) : new CustomTabsIntent.Builder();
        this.mCustomTabsIntent = builder.setShowTitle(true).build();
        this.mCustomTabsIntent.intent.setPackage(this.mChromePackageWithCustomTabSupport);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Logger.info(TAG, null, "onNewIntent is called, received redirect from system webview.");
        String url = intent.getStringExtra("com.microsoft.identity.customtab.redirect");
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", url);
        this.returnToCaller(2003, resultIntent);
    }

    protected void onResume() {
        super.onResume();
        if (this.mRestarted) {
            this.cancelRequest();
            return;
        }
        this.mRestarted = true;
        this.mRequestUrl = this.getIntent().getStringExtra("com.microsoft.identity.request.url.key");
        Logger.infoPII(TAG, null, "Request to launch is: " + this.mRequestUrl);
        if (this.mChromePackageWithCustomTabSupport != null) {
            Logger.info(TAG, null, "ChromeCustomTab support is available, launching chrome tab.");
            this.mCustomTabsIntent.launchUrl((Context)this, Uri.parse((String)this.mRequestUrl));
        } else {
            Logger.info(TAG, null, "Chrome tab support is not available, launching chrome browser.");
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)this.mRequestUrl));
            browserIntent.setPackage(MsalUtils.getChromePackage(this.getApplicationContext()));
            browserIntent.addCategory("android.intent.category.BROWSABLE");
            this.startActivity(browserIntent);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("com.microsoft.identity.request.url.key", this.mRequestUrl);
        outState.putString("com.microsoft.identity.telemetry.request.id", this.mTelemetryRequestId);
    }

    void cancelRequest() {
        Logger.verbose(TAG, null, "Cancel the authentication request.");
        this.mUiEventBuilder.setUserDidCancel();
        this.returnToCaller(2001, new Intent());
    }

    private void returnToCaller(int resultCode, Intent data) {
        Logger.info(TAG, null, "Return to caller with resultCode: " + resultCode + "; requestId: " + this.mRequestId);
        data.putExtra("com.microsoft.aad.adal:RequestId", this.mRequestId);
        if (null != this.mUiEventBuilder) {
            Telemetry.getInstance().stopEvent(this.mTelemetryRequestId, this.mUiEventBuilder);
        }
        this.setResult(resultCode, data);
        this.finish();
    }

    private void sendError(String errorCode, String errorDescription) {
        Logger.info(TAG, null, "Sending error back to the caller, errorCode: " + errorCode + "; errorDescription" + errorDescription);
        Intent errorIntent = new Intent();
        errorIntent.putExtra("error_code", errorCode);
        errorIntent.putExtra("error_description", errorDescription);
        this.returnToCaller(2002, errorIntent);
    }

    private static class MsalCustomTabsServiceConnection
    extends CustomTabsServiceConnection {
        private static final String TAG = MsalCustomTabsServiceConnection.class.getSimpleName();
        private final WeakReference<CountDownLatch> mLatchWeakReference;
        private CustomTabsClient mCustomTabsClient;
        private CustomTabsSession mCustomTabsSession;
        private boolean mCustomTabsServiceIsBound;

        MsalCustomTabsServiceConnection(CountDownLatch latch) {
            this.mLatchWeakReference = new WeakReference<CountDownLatch>(latch);
        }

        public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
            String methodName = ":onCustomTabsServiceConnected";
            com.microsoft.identity.common.internal.logging.Logger.info((String)(TAG + ":onCustomTabsServiceConnected"), (String)"Connected.");
            CountDownLatch latch = (CountDownLatch)this.mLatchWeakReference.get();
            this.mCustomTabsServiceIsBound = true;
            this.mCustomTabsClient = client;
            this.mCustomTabsClient.warmup(0L);
            this.mCustomTabsSession = this.mCustomTabsClient.newSession(null);
            if (null != latch) {
                latch.countDown();
                com.microsoft.identity.common.internal.logging.Logger.verbose((String)(TAG + ":onCustomTabsServiceConnected"), (String)"Decrementing latch");
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            String methodName = ":onServiceDisconnected";
            this.mCustomTabsServiceIsBound = false;
            com.microsoft.identity.common.internal.logging.Logger.info((String)(TAG + ":onServiceDisconnected"), (String)"Disconnected.");
        }

        CustomTabsSession getCustomTabsSession() {
            return this.mCustomTabsSession;
        }

        boolean getCustomTabsServiceIsBound() {
            return this.mCustomTabsServiceIsBound;
        }
    }
}

