/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.telemetry;

import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.telemetry.Event;
import com.microsoft.identity.client.internal.telemetry.HttpEvent;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public final class ApiEvent
extends Event {
    private static final String TAG = ApiEvent.class.getSimpleName();

    private ApiEvent(Builder builder) {
        super(builder);
        if (null != builder.mCorrelationId) {
            this.setProperty("msal.correlation_id", builder.mCorrelationId.toString());
        }
        if (null != builder.mRequestId) {
            this.setProperty("msal.request_id", builder.mRequestId);
        }
        this.setProperty("msal.authority", HttpEvent.sanitizeUrlForTelemetry(builder.mAuthority));
        this.setProperty("msal.ui_behavior", builder.mUiBehavior);
        this.setProperty("msal.api_id", builder.mApiId);
        this.setProperty("msal.authority_validation_status", builder.mValidationStatus);
        this.setLoginHint(builder.mLoginHint);
        this.setProperty("msal.is_successful", String.valueOf(builder.mWasApiCallSuccessful));
        this.setProperty("msal.api_error_code", builder.mApiErrorCode);
    }

    public void setLoginHint(String loginHint) {
        try {
            this.setProperty("msal.login_hint", MsalUtils.createHash(loginHint));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            Logger.info((String)TAG, null, (String)"Skipping telemetry for LOGIN_HINT");
        }
    }

    public String getAuthority() {
        return this.getProperty("msal.authority");
    }

    public String getUiBehavior() {
        return this.getProperty("msal.ui_behavior");
    }

    public String getApiId() {
        return this.getProperty("msal.api_id");
    }

    public String getValidationStatus() {
        return this.getProperty("msal.authority_validation_status");
    }

    public String getIdpName() {
        return this.getProperty("msal.idp");
    }

    public String getTenantId() {
        return this.getProperty("msal.tenant_id");
    }

    public String getUserId() {
        return this.getProperty("msal.user_id");
    }

    public String getLoginHint() {
        return this.getProperty("msal.login_hint");
    }

    public Boolean wasSuccessful() {
        return Boolean.valueOf(this.getProperty("msal.is_successful"));
    }

    public String getRequestId() {
        return this.getProperty("msal.request_id");
    }

    public String getAuthorityType() {
        return this.getProperty("msal.authority_type");
    }

    public String getApiErrorCode() {
        return this.getProperty("msal.api_error_code");
    }

    public static class Builder
    extends Event.Builder<Builder> {
        private String mAuthority;
        private String mUiBehavior;
        private String mApiId;
        private String mValidationStatus;
        private String mRawIdToken;
        private String mLoginHint;
        private boolean mWasApiCallSuccessful;
        private UUID mCorrelationId;
        private String mRequestId;
        private String mApiErrorCode;

        public Builder(String requestId) {
            super("msal.api_event");
            this.mRequestId = requestId;
        }

        public Builder setAuthority(String authority) {
            this.mAuthority = authority;
            return this;
        }

        public Builder setUiBehavior(String uiBehavior) {
            this.mUiBehavior = uiBehavior;
            return this;
        }

        public Builder setApiId(String apiId) {
            this.mApiId = apiId;
            return this;
        }

        public Builder setValidationStatus(String validationStatus) {
            this.mValidationStatus = validationStatus;
            return this;
        }

        public Builder setRawIdToken(String rawIdToken) {
            this.mRawIdToken = rawIdToken;
            return this;
        }

        public Builder setLoginHint(String loginHint) {
            this.mLoginHint = loginHint;
            return this;
        }

        public Builder setApiCallWasSuccessful(boolean callWasSuccessful) {
            this.mWasApiCallSuccessful = callWasSuccessful;
            return this;
        }

        public Builder setCorrelationId(UUID correlationId) {
            this.mCorrelationId = correlationId;
            return this;
        }

        public Builder setApiErrorCode(String errorCode) {
            this.mApiErrorCode = errorCode;
            return this;
        }

        @Override
        public ApiEvent build() {
            return new ApiEvent(this);
        }
    }
}

