/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.Intent;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.internal.controllers.AcquireTokenResult;
import com.microsoft.identity.client.internal.controllers.MSALAcquireTokenOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALController;
import com.microsoft.identity.client.internal.controllers.MSALOperationParameters;
import com.microsoft.identity.client.internal.controllers.MSALTokenCommand;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class MSALInteractiveTokenCommand
extends MSALTokenCommand {
    private static final String TAG = MSALInteractiveTokenCommand.class.getSimpleName();

    public MSALInteractiveTokenCommand(Context context, MSALOperationParameters parameters, MSALController controller, AuthenticationCallback callback) {
        this.mContext = context;
        this.mParameters = parameters;
        this.mController = controller;
        this.mCallback = callback;
        if (!(this.mParameters instanceof MSALAcquireTokenOperationParameters)) {
            throw new IllegalArgumentException("Invalid operation parameters");
        }
    }

    @Override
    public AcquireTokenResult execute() throws InterruptedException, ExecutionException, IOException, ClientException, MsalClientException, MsalArgumentException {
        String methodName = ":execute";
        if (this.getParameters() instanceof MSALAcquireTokenOperationParameters) {
            Logger.info((String)(TAG + ":execute"), (String)"Executing interactive token command...");
            return this.getController().acquireToken((MSALAcquireTokenOperationParameters)this.getParameters());
        }
        throw new IllegalArgumentException("Invalid operation parameters");
    }

    @Override
    public void notify(int requestCode, int resultCode, Intent data) {
        this.getController().completeAcquireToken(requestCode, resultCode, data);
    }
}

