/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.exception.MsalServiceException;
import com.microsoft.identity.client.exception.MsalUiRequiredException;
import com.microsoft.identity.client.exception.MsalUserCancelException;
import com.microsoft.identity.client.internal.controllers.AcquireTokenResult;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.IOException;

public class ExceptionAdapter {
    private static final String TAG = ExceptionAdapter.class.getSimpleName();

    public static MsalException exceptionFromAcquireTokenResult(AcquireTokenResult result) {
        String methodName = ":exceptionFromAcquireTokenResult";
        AuthorizationResult authorizationResult = result.getAuthorizationResult();
        if (null != authorizationResult) {
            AuthorizationErrorResponse authorizationErrorResponse = authorizationResult.getAuthorizationErrorResponse();
            if (!authorizationResult.getSuccess()) {
                switch (result.getAuthorizationResult().getAuthorizationStatus()) {
                    case FAIL: {
                        return new MsalServiceException(authorizationErrorResponse.getError(), authorizationErrorResponse.getError() + ";" + authorizationErrorResponse.getErrorDescription(), 0, null);
                    }
                    case USER_CANCEL: {
                        return new MsalUserCancelException();
                    }
                }
            }
        } else {
            Logger.warn((String)(TAG + ":exceptionFromAcquireTokenResult"), (String)"AuthorizationResult was null -- expected for ATS cases.");
        }
        TokenResult tokenResult = result.getTokenResult();
        if (!result.getTokenResult().getSuccess()) {
            TokenErrorResponse tokenErrorResponse = tokenResult.getErrorResponse();
            if (tokenErrorResponse.getError().equalsIgnoreCase("invalid_grant")) {
                Logger.warn((String)(TAG + ":exceptionFromAcquireTokenResult"), (String)"Received invalid_grant");
                return new MsalUiRequiredException(tokenErrorResponse.getError(), tokenErrorResponse.getErrorDescription(), null);
            }
            if (StringUtil.isEmpty((String)tokenErrorResponse.getError())) {
                Logger.warn((String)(TAG + ":exceptionFromAcquireTokenResult"), (String)"Received unknown error");
                return new MsalServiceException("unknown_error", "Request failed, but no error returned back from service.", null);
            }
            return new MsalServiceException(tokenErrorResponse.getError(), tokenErrorResponse.getErrorDescription(), null);
        }
        return null;
    }

    public static MsalException msalExceptionFromException(Exception e) {
        MsalClientException msalException = null;
        if (e instanceof IOException) {
            msalException = new MsalClientException("io_error", "An IO error occurred with message: " + e.getMessage(), e);
        }
        if (e instanceof ClientException) {
            msalException = new MsalClientException(((ClientException)e).getErrorCode(), e.getMessage(), e);
        }
        if (msalException == null) {
            msalException = new MsalClientException("unknown_error", e.getMessage(), e);
        }
        return msalException;
    }
}

