/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.authorities;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.internal.authorities.AccountsInOneOrganization;
import com.microsoft.identity.client.internal.authorities.AllAccounts;
import com.microsoft.identity.client.internal.authorities.AnyOrganizationalAccount;
import com.microsoft.identity.client.internal.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.internal.logging.Logger;

public abstract class AzureActiveDirectoryAudience {
    private static final String TAG = AzureActiveDirectoryAudience.class.getSimpleName();
    private String cloudUrl;
    @SerializedName(value="tenant_id")
    private String tenantId;
    public static final String ORGANIZATIONS = "organizations";
    public static final String CONSUMERS = "consumers";
    public static final String ALL = "common";

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public static AzureActiveDirectoryAudience getAzureActiveDirectoryAudience(String cloudUrl, String tenantId) {
        String methodName = ":getAzureActiveDirectoryAudience";
        AzureActiveDirectoryAudience audience = null;
        switch (tenantId.toLowerCase()) {
            case "organizations": {
                Logger.verbose((String)(TAG + ":getAzureActiveDirectoryAudience"), (String)"Audience: AnyOrganizationalAccount");
                audience = new AnyOrganizationalAccount(cloudUrl);
                break;
            }
            case "consumers": {
                Logger.verbose((String)(TAG + ":getAzureActiveDirectoryAudience"), (String)"Audience: AnyPersonalAccount");
                audience = new AnyPersonalAccount();
                break;
            }
            case "common": {
                Logger.verbose((String)(TAG + ":getAzureActiveDirectoryAudience"), (String)"Audience: AllAccounts");
                audience = new AllAccounts();
                break;
            }
            default: {
                Logger.verbose((String)(TAG + ":getAzureActiveDirectoryAudience"), (String)"Audience: AccountsInOneOrganization");
                audience = new AccountsInOneOrganization(cloudUrl, tenantId);
            }
        }
        return audience;
    }
}

