/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.authorities;

import android.net.Uri;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.AzureActiveDirectoryAccountIdentifier;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.internal.authorities.ActiveDirectoryFederationServicesAuthority;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.client.internal.authorities.UnknownAuthority;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public abstract class Authority {
    private static final String TAG = Authority.class.getSimpleName();
    private static final String ADFS_PATH_SEGMENT = "adfs";
    private static final String B2C_PATH_SEGMENT = "tfp";
    protected boolean mKnownToMicrosoft = false;
    protected boolean mKnownToDeveloper = false;
    @SerializedName(value="default")
    protected boolean mIsDefault = false;
    @SerializedName(value="type")
    protected String mAuthorityTypeString;
    @SerializedName(value="authority_url")
    protected String mAuthorityUrl;
    private static List<Authority> knownAuthorities = new ArrayList<Authority>();
    private static Object sLock = new Object();

    public abstract Uri getAuthorityUri();

    public abstract URL getAuthorityURL();

    public boolean getDefault() {
        return this.mIsDefault;
    }

    public static Authority getAuthorityFromAuthorityUrl(String authorityUrl) {
        URL authUrl;
        String methodName = ":getAuthorityFromAuthorityUrl";
        try {
            authUrl = new URL(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid authority URL");
        }
        Uri authorityUri = Uri.parse((String)authUrl.toString());
        List pathSegments = authorityUri.getPathSegments();
        if (pathSegments.size() == 0) {
            return new UnknownAuthority();
        }
        String authorityType = (String)pathSegments.get(0);
        Authority authority = null;
        switch (authorityType.toLowerCase()) {
            case "adfs": {
                Logger.verbose((String)(TAG + ":getAuthorityFromAuthorityUrl"), (String)"Authority type is ADFS");
                authority = new ActiveDirectoryFederationServicesAuthority(authorityUrl);
                break;
            }
            case "tfp": {
                Logger.verbose((String)(TAG + ":getAuthorityFromAuthorityUrl"), (String)"Authority type is B2C");
                authority = new AzureActiveDirectoryB2CAuthority(authorityUrl);
                break;
            }
            default: {
                Logger.verbose((String)(TAG + ":getAuthorityFromAuthorityUrl"), (String)"Authority type default: AAD");
                AzureActiveDirectoryAudience audience = AzureActiveDirectoryAudience.getAzureActiveDirectoryAudience(authorityUri.getScheme() + "://" + authorityUri.getHost(), (String)pathSegments.get(0));
                authority = new AzureActiveDirectoryAuthority(audience);
            }
        }
        return authority;
    }

    public abstract OAuth2Strategy createOAuth2Strategy();

    protected boolean getKnownToMicrosoft() {
        return this.mKnownToMicrosoft;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Authority)) {
            return false;
        }
        Authority authority = (Authority)o;
        if (!this.mAuthorityTypeString.equals(authority.mAuthorityTypeString)) {
            return false;
        }
        return this.getAuthorityURL().equals(authority.getAuthorityURL());
    }

    public int hashCode() {
        int result = this.mAuthorityTypeString.hashCode();
        result = 31 * result + this.getAuthorityURL().hashCode();
        return result;
    }

    protected boolean getKnownToDeveloper() {
        return this.mKnownToDeveloper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCloudDiscovery() throws IOException {
        String methodName = ":performCloudDiscovery";
        Logger.verbose((String)(TAG + ":performCloudDiscovery"), (String)"Performing cloud discovery...");
        Object object = sLock;
        synchronized (object) {
            if (!AzureActiveDirectory.isInitialized()) {
                AzureActiveDirectory.performCloudDiscovery();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKnownAuthorities(List<Authority> authorities) {
        Object object = sLock;
        synchronized (object) {
            knownAuthorities.addAll(authorities);
        }
    }

    public static boolean isKnownAuthority(Authority authority) {
        String methodName = ":isKnownAuthority";
        boolean knownToDeveloper = false;
        boolean knownToMicrosoft = false;
        if (authority == null) {
            Logger.warn((String)(TAG + ":isKnownAuthority"), (String)"Authority is null");
            return false;
        }
        knownToDeveloper = knownAuthorities.contains(authority);
        knownToMicrosoft = AzureActiveDirectory.hasCloudHost((URL)authority.getAuthorityURL());
        boolean isKnown = knownToDeveloper || knownToMicrosoft;
        Logger.verbose((String)(TAG + ":isKnownAuthority"), (String)("Authority is known to developer? [" + knownToDeveloper + "]"));
        Logger.verbose((String)(TAG + ":isKnownAuthority"), (String)("Authority is known to Microsoft? [" + knownToMicrosoft + "]"));
        return isKnown;
    }

    public static KnownAuthorityResult getKnownAuthorityResult(Authority authority) {
        String methodName = ":getKnownAuthorityResult";
        Logger.verbose((String)(TAG + ":getKnownAuthorityResult"), (String)"Getting known authority result...");
        MsalClientException msalClientException = null;
        boolean known = false;
        try {
            Logger.verbose((String)(TAG + ":getKnownAuthorityResult"), (String)"Performing cloud discovery");
            Authority.performCloudDiscovery();
        }
        catch (IOException ex) {
            msalClientException = new MsalClientException("io_error", "Unable to perform cloud discovery", ex);
        }
        if (msalClientException == null) {
            if (!Authority.isKnownAuthority(authority)) {
                msalClientException = new MsalClientException("unknown_authority", "Provided authority is not known.  MSAL will only make requests to known authorities");
            } else {
                known = true;
            }
        }
        return new KnownAuthorityResult(known, msalClientException);
    }

    public static String getAuthorityFromAccount(IAccount account) {
        AzureActiveDirectoryAccountIdentifier aadIdentifier;
        String methodName = ":getAuthorityFromAccount";
        Logger.verbose((String)(TAG + ":getAuthorityFromAccount"), (String)"Getting authority from account...");
        if (null != account && null != account.getAccountIdentifier() && account.getAccountIdentifier() instanceof AzureActiveDirectoryAccountIdentifier && null != (aadIdentifier = (AzureActiveDirectoryAccountIdentifier)account.getAccountIdentifier()).getTenantIdentifier() && !StringUtil.isEmpty((String)aadIdentifier.getTenantIdentifier())) {
            return "https://" + account.getEnvironment() + "/" + aadIdentifier.getTenantIdentifier() + "/";
        }
        Logger.warn((String)(TAG + ":getAuthorityFromAccount"), (String)"Account was null...");
        return null;
    }

    public static class KnownAuthorityResult {
        private boolean mKnown = false;
        private MsalClientException mMsalClientException = null;

        KnownAuthorityResult(boolean known, MsalClientException exception) {
            this.mKnown = known;
            this.mMsalClientException = exception;
        }

        public boolean getKnown() {
            return this.mKnown;
        }

        public MsalClientException getMsalClientException() {
            return this.mMsalClientException;
        }
    }
}

