/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.support.annotation.NonNull;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.configuration.HttpConfiguration;
import com.microsoft.identity.client.configuration.LoggerConfiguration;
import com.microsoft.identity.client.internal.authorities.Authority;
import com.microsoft.identity.client.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.client.internal.authorities.UnknownAudience;
import com.microsoft.identity.client.internal.authorities.UnknownAuthority;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import java.util.List;

public class PublicClientApplicationConfiguration {
    @SerializedName(value="client_id")
    String mClientId;
    @SerializedName(value="redirect_uri")
    String mRedirectUri;
    @SerializedName(value="authorities")
    List<Authority> mAuthorities;
    @SerializedName(value="authorization_user_agent")
    AuthorizationAgent mAuthorizationAgent;
    @SerializedName(value="http")
    HttpConfiguration mHttpConfiguration;
    @SerializedName(value="logging")
    LoggerConfiguration mLoggerConfiguration;

    public String getClientId() {
        return this.mClientId;
    }

    public List<Authority> getAuthorities() {
        return this.mAuthorities;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.mHttpConfiguration;
    }

    public LoggerConfiguration getLoggerConfiguration() {
        return this.mLoggerConfiguration;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public AuthorizationAgent getAuthorizationAgent() {
        return this.mAuthorizationAgent;
    }

    public Authority getDefaultAuthority() {
        if (this.mAuthorities != null) {
            if (this.mAuthorities.size() > 1) {
                for (Authority authority : this.mAuthorities) {
                    if (!authority.getDefault()) continue;
                    return authority;
                }
                return null;
            }
            return this.mAuthorities.get(0);
        }
        return null;
    }

    private void checkDefaultAuthoritySpecified() {
        if (this.mAuthorities != null && this.mAuthorities.size() > 1) {
            int defaultCount = 0;
            for (Authority authority : this.mAuthorities) {
                if (!authority.getDefault()) continue;
                ++defaultCount;
            }
            if (defaultCount == 0) {
                throw new IllegalArgumentException("One authority in your configuration must be marked as default.");
            }
            if (defaultCount > 1) {
                throw new IllegalArgumentException("More than one authority in your configuration is marked as default.  Only one authority may be default.");
            }
        }
    }

    boolean isDefaultAuthorityConfigured() {
        Authority authority = this.getDefaultAuthority();
        return authority != null;
    }

    void mergeConfiguration(PublicClientApplicationConfiguration config) {
        this.mClientId = config.mClientId == null ? this.mClientId : config.mClientId;
        this.mRedirectUri = config.mRedirectUri == null ? this.mRedirectUri : config.mRedirectUri;
        this.mAuthorities = config.mAuthorities == null ? this.mAuthorities : config.mAuthorities;
        this.mAuthorizationAgent = config.mAuthorizationAgent == null ? this.mAuthorizationAgent : config.mAuthorizationAgent;
        this.mHttpConfiguration = config.mHttpConfiguration == null ? this.mHttpConfiguration : config.mHttpConfiguration;
    }

    void validateConfiguration() {
        this.nullConfigurationCheck("redirect_uri", this.mRedirectUri);
        this.nullConfigurationCheck("client_id", this.mClientId);
        this.checkDefaultAuthoritySpecified();
        for (Authority authority : this.mAuthorities) {
            if (authority instanceof UnknownAuthority) {
                throw new IllegalArgumentException("Unrecognized authority type -- null, invalid or unknown type specified.");
            }
            if (!(authority instanceof AzureActiveDirectoryAuthority)) continue;
            this.validateAzureActiveDirectoryAuthority((AzureActiveDirectoryAuthority)authority);
        }
    }

    private void validateAzureActiveDirectoryAuthority(@NonNull AzureActiveDirectoryAuthority azureActiveDirectoryAuthority) {
        if (null != azureActiveDirectoryAuthority.mAudience && azureActiveDirectoryAuthority.mAudience instanceof UnknownAudience) {
            throw new IllegalArgumentException("Unrecognized audience type for AzureActiveDirectoryAuthority -- null, invalid, or unknown type specified");
        }
    }

    void nullConfigurationCheck(String configKey, String configValue) {
        if (configValue == null) {
            throw new IllegalArgumentException(configKey + " cannot be null.  Invalid configuration.");
        }
    }

    public static final class SerializedNames {
        static final String CLIENT_ID = "client_id";
        static final String REDIRECT_URI = "redirect_uri";
        static final String AUTHORITIES = "authorities";
        static final String AUTHORIZATION_USER_AGENT = "authorization_user_agent";
        static final String HTTP = "http";
        static final String LOGGING = "logging";
    }
}

