/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.ILoggerCallback;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.concurrent.atomic.AtomicReference;

public final class Logger {
    private static final Logger sINSTANCE = new Logger();
    private AtomicReference<ILoggerCallback> mExternalLogger = new AtomicReference<Object>(null);

    public static Logger getInstance() {
        return sINSTANCE;
    }

    public void setLogLevel(LogLevel logLevel) {
        switch (logLevel) {
            case ERROR: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.ERROR);
                break;
            }
            case WARNING: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.WARN);
                break;
            }
            case INFO: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.INFO);
                break;
            }
            case VERBOSE: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.VERBOSE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logLevel");
            }
        }
    }

    public void setExternalLogger(ILoggerCallback externalLogger) {
        if (externalLogger == null) {
            return;
        }
        if (this.mExternalLogger.get() != null) {
            throw new IllegalStateException("External logger is already set, cannot be set again.");
        }
        com.microsoft.identity.common.internal.logging.Logger.getInstance().setExternalLogger(new com.microsoft.identity.common.internal.logging.ILoggerCallback(){

            public void log(String tag, Logger.LogLevel logLevel, String message, boolean containsPII) {
                switch (logLevel) {
                    case ERROR: {
                        ((ILoggerCallback)Logger.this.mExternalLogger.get()).log(tag, LogLevel.ERROR, message, containsPII);
                        break;
                    }
                    case WARN: {
                        ((ILoggerCallback)Logger.this.mExternalLogger.get()).log(tag, LogLevel.WARNING, message, containsPII);
                        break;
                    }
                    case VERBOSE: {
                        ((ILoggerCallback)Logger.this.mExternalLogger.get()).log(tag, LogLevel.VERBOSE, message, containsPII);
                        break;
                    }
                    case INFO: {
                        ((ILoggerCallback)Logger.this.mExternalLogger.get()).log(tag, LogLevel.INFO, message, containsPII);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown logLevel");
                    }
                }
            }
        });
        this.mExternalLogger.set(externalLogger);
    }

    public void setEnableLogcatLog(boolean enableLogcatLog) {
        com.microsoft.identity.common.internal.logging.Logger.setAllowLogcat((boolean)enableLogcatLog);
    }

    public void setEnablePII(boolean enablePII) {
        com.microsoft.identity.common.internal.logging.Logger.setAllowPii((boolean)enablePII);
    }

    @Deprecated
    public static void error(String tag, RequestContext requestContext, String errorMessage, Throwable exception) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.ERROR, requestContext, errorMessage, exception, false);
    }

    @Deprecated
    public static void errorPII(String tag, RequestContext requestContext, String errorMessage, Throwable exception) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.ERROR, requestContext, errorMessage, exception, true);
    }

    @Deprecated
    public static void warning(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.WARNING, requestContext, message, null, false);
    }

    @Deprecated
    public static void warningPII(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.WARNING, requestContext, message, null, true);
    }

    @Deprecated
    static void info(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.INFO, requestContext, message, null, false);
    }

    @Deprecated
    static void infoPII(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.INFO, requestContext, message, null, true);
    }

    @Deprecated
    static void verbose(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.VERBOSE, requestContext, message, null, false);
    }

    @Deprecated
    static void verbosePII(String tag, RequestContext requestContext, String message) {
        Logger.getInstance().commonCoreWrapper(tag, LogLevel.VERBOSE, requestContext, message, null, true);
    }

    private String getCorrelationId(RequestContext requestContext) {
        if (requestContext != null && requestContext.getCorrelationId() != null) {
            return requestContext.getCorrelationId().toString();
        }
        return null;
    }

    private void commonCoreWrapper(String tag, LogLevel logLevel, RequestContext requestContext, String message, Throwable throwable, boolean containsPII) {
        String messageWithComponent = this.appendComponent(requestContext) + message + " SDK ver:" + "0.2.0";
        String correlationID = this.getCorrelationId(requestContext);
        switch (logLevel) {
            case ERROR: {
                if (containsPII) {
                    com.microsoft.identity.common.internal.logging.Logger.errorPII((String)tag, (String)correlationID, (String)messageWithComponent, (Throwable)throwable);
                    break;
                }
                com.microsoft.identity.common.internal.logging.Logger.error((String)tag, (String)correlationID, (String)messageWithComponent, (Throwable)throwable);
                break;
            }
            case WARNING: {
                if (containsPII) {
                    com.microsoft.identity.common.internal.logging.Logger.warnPII((String)tag, (String)correlationID, (String)messageWithComponent);
                    break;
                }
                com.microsoft.identity.common.internal.logging.Logger.warn((String)tag, (String)correlationID, (String)messageWithComponent);
                break;
            }
            case INFO: {
                if (containsPII) {
                    com.microsoft.identity.common.internal.logging.Logger.infoPII((String)tag, (String)correlationID, (String)messageWithComponent);
                    break;
                }
                com.microsoft.identity.common.internal.logging.Logger.info((String)tag, (String)correlationID, (String)messageWithComponent);
                break;
            }
            case VERBOSE: {
                if (containsPII) {
                    com.microsoft.identity.common.internal.logging.Logger.verbosePII((String)tag, (String)correlationID, (String)messageWithComponent);
                    break;
                }
                com.microsoft.identity.common.internal.logging.Logger.verbose((String)tag, (String)correlationID, (String)messageWithComponent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logLevel");
            }
        }
    }

    private String appendComponent(RequestContext requestContext) {
        if (requestContext != null && !MsalUtils.isEmpty(requestContext.getComponent())) {
            return "(" + requestContext.getComponent() + ") ";
        }
        return "";
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        VERBOSE;

    }
}

