/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Account;
import com.microsoft.identity.client.AccountIdentifier;
import com.microsoft.identity.client.AzureActiveDirectoryAccountIdentifier;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;

class AccountAdapter {
    private static final String TAG = AccountAdapter.class.getSimpleName();

    AccountAdapter() {
    }

    static IAccount adapt(final AccountRecord accountIn) {
        AccountIdentifier homeAccountId;
        AccountIdentifier accountId;
        String methodName = ":adapt";
        Account accountOut = new Account();
        if ("MSSTS".equals(accountIn.getAuthorityType())) {
            Logger.info((String)(TAG + ":adapt"), (String)"Account type is AAD");
            accountId = new AzureActiveDirectoryAccountIdentifier(){
                {
                    this.setIdentifier(accountIn.getLocalAccountId());
                    this.setObjectIdentifier(accountIn.getLocalAccountId());
                    this.setTenantIdentifier(accountIn.getRealm());
                }
            };
            homeAccountId = new AzureActiveDirectoryAccountIdentifier(){
                {
                    String homeAccountIdStr = accountIn.getHomeAccountId();
                    String[] components = homeAccountIdStr.split("\\.");
                    this.setIdentifier(homeAccountIdStr);
                    this.setObjectIdentifier(components[0]);
                    this.setTenantIdentifier(components[1]);
                }
            };
        } else {
            Logger.info((String)(TAG + ":adapt"), (String)"Account is non-AAD");
            accountId = new AccountIdentifier(){
                {
                    this.setIdentifier(accountIn.getLocalAccountId());
                }
            };
            homeAccountId = new AccountIdentifier(){
                {
                    this.setIdentifier(accountIn.getHomeAccountId());
                }
            };
        }
        accountOut.setAccountIdentifier(accountId);
        accountOut.setHomeAccountIdentifier(homeAccountId);
        accountOut.setUsername(accountIn.getUsername());
        accountOut.setEnvironment(accountIn.getEnvironment());
        Logger.verbosePII((String)(TAG + ":adapt"), (String)("Username: [" + accountIn.getUsername() + "]"));
        Logger.verbosePII((String)(TAG + ":adapt"), (String)("Environment: [" + accountIn.getEnvironment() + "]"));
        return accountOut;
    }
}

