/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Event;

final class UiEvent
extends Event {
    private UiEvent(Builder builder) {
        super(builder);
        this.setProperty("msal.user_agent", builder.mUserAgent);
        this.setProperty("msal.user_cancel", builder.mUserDidCancel);
    }

    String getUserAgent() {
        return this.getProperty("msal.user_agent");
    }

    Boolean userCancelled() {
        return Boolean.valueOf(this.getProperty("msal.user_cancel"));
    }

    static class Builder
    extends Event.Builder<Builder> {
        private String mUserAgent;
        private String mUserDidCancel = "false";

        Builder() {
            super("msal.ui_event");
        }

        Builder setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        Builder setUserDidCancel() {
            this.mUserDidCancel = "true";
            return this;
        }

        @Override
        UiEvent build() {
            return new UiEvent(this);
        }
    }
}

