/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.microsoft.identity.client.AccessTokenCacheItem;
import com.microsoft.identity.client.BaseTokenCacheItem;
import com.microsoft.identity.client.ClientInfo;
import com.microsoft.identity.client.IdToken;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.RefreshTokenCacheItem;
import com.microsoft.identity.client.User;
import java.lang.reflect.Type;

final class TokenCacheItemDeserializer<T extends BaseTokenCacheItem>
implements JsonDeserializer<T> {
    TokenCacheItemDeserializer() {
    }

    public T deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        User user;
        ClientInfo clientInfo;
        BaseTokenCacheItem deserializedTokenCacheItem = (BaseTokenCacheItem)new Gson().fromJson(json, type);
        try {
            clientInfo = new ClientInfo(deserializedTokenCacheItem.getRawClientInfo());
        }
        catch (MsalClientException e) {
            throw new JsonParseException("Fail to deserialize", (Throwable)e);
        }
        deserializedTokenCacheItem.setClientInfo(clientInfo);
        if (deserializedTokenCacheItem instanceof AccessTokenCacheItem) {
            AccessTokenCacheItem accessTokenCacheItem = (AccessTokenCacheItem)deserializedTokenCacheItem;
            try {
                user = User.create(new IdToken(accessTokenCacheItem.getRawIdToken()), clientInfo);
            }
            catch (MsalClientException e) {
                throw new JsonParseException("Fail to deserialize", (Throwable)e);
            }
        } else {
            RefreshTokenCacheItem refreshTokenCacheItem = (RefreshTokenCacheItem)deserializedTokenCacheItem;
            user = new User(refreshTokenCacheItem.getDisplayableId(), refreshTokenCacheItem.getName(), refreshTokenCacheItem.getIdentityProvider(), clientInfo.getUniqueIdentifier(), clientInfo.getUniqueTenantIdentifier());
        }
        deserializedTokenCacheItem.setUser(user);
        return (T)deserializedTokenCacheItem;
    }
}

