/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.AccessTokenCacheItem;
import com.microsoft.identity.client.AccessTokenCacheKey;
import com.microsoft.identity.client.AuthenticationRequestParameters;
import com.microsoft.identity.client.BaseTokenCacheItem;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.RefreshTokenCacheItem;
import com.microsoft.identity.client.RefreshTokenCacheKey;
import com.microsoft.identity.client.RequestContext;
import com.microsoft.identity.client.TokenCacheAccessor;
import com.microsoft.identity.client.TokenCacheItemDeserializer;
import com.microsoft.identity.client.TokenResponse;
import com.microsoft.identity.client.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

class TokenCache {
    private static final String TAG = TokenCache.class.getSimpleName();
    private static final int DEFAULT_EXPIRATION_BUFFER = 300;
    private final TokenCacheAccessor mTokenCacheAccessor;
    private Gson mGson = new GsonBuilder().registerTypeAdapter(AccessTokenCacheItem.class, new TokenCacheItemDeserializer()).registerTypeAdapter(RefreshTokenCacheItem.class, new TokenCacheItemDeserializer()).create();

    TokenCache(Context context) {
        this.mTokenCacheAccessor = new TokenCacheAccessor(context);
    }

    AccessTokenCacheItem saveAccessToken(String authority, String clientId, TokenResponse response, RequestContext requestContext) throws MsalClientException {
        Logger.info(TAG, null, "Starting to Save access token into cache.");
        Logger.infoPII(TAG, null, "Access token will be saved with authority: " + authority + "; Client Id: " + clientId + "; Scopes: " + response.getScope());
        AccessTokenCacheItem newAccessToken = new AccessTokenCacheItem(authority, clientId, response);
        AccessTokenCacheKey accessTokenCacheKey = newAccessToken.extractTokenCacheKey();
        List<AccessTokenCacheItem> accessTokenCacheItems = this.getAllAccessTokensForApp(clientId, requestContext);
        for (AccessTokenCacheItem accessTokenCacheItem : accessTokenCacheItems) {
            if (!accessTokenCacheKey.matches(accessTokenCacheItem) || !MsalUtils.isScopeIntersects(newAccessToken.getScope(), accessTokenCacheItem.getScope())) continue;
            this.mTokenCacheAccessor.deleteAccessToken(accessTokenCacheItem.extractTokenCacheKey().toString(), requestContext);
        }
        this.mTokenCacheAccessor.saveAccessToken(newAccessToken.extractTokenCacheKey().toString(), this.mGson.toJson((Object)newAccessToken), requestContext);
        return newAccessToken;
    }

    void saveRefreshToken(String authorityHost, String clientId, TokenResponse response, RequestContext requestContext) throws MsalClientException {
        if (!MsalUtils.isEmpty(response.getRefreshToken())) {
            Logger.info(TAG, requestContext, "Starting to save refresh token into cache.");
            Logger.infoPII(TAG, requestContext, "Refresh token will be saved with authority: " + authorityHost + "; Client Id: " + clientId);
            RefreshTokenCacheItem refreshTokenCacheItem = new RefreshTokenCacheItem(authorityHost, clientId, response);
            this.mTokenCacheAccessor.saveRefreshToken(refreshTokenCacheItem.extractTokenCacheKey().toString(), this.mGson.toJson((Object)refreshTokenCacheItem), requestContext);
        }
    }

    AccessTokenCacheItem findAccessToken(AuthenticationRequestParameters requestParam, User user) {
        AccessTokenCacheKey key = AccessTokenCacheKey.createTokenCacheKey(requestParam.getAuthority().getAuthority(), requestParam.getClientId(), requestParam.getScope(), user);
        List<AccessTokenCacheItem> accessTokenCacheItems = this.getAccessTokens(key, requestParam.getRequestContext());
        if (accessTokenCacheItems.isEmpty()) {
            Logger.info(TAG, requestParam.getRequestContext(), "No access is found for scopes: " + MsalUtils.convertSetToString(requestParam.getScope(), " "));
            if (user != null) {
                Logger.infoPII(TAG, requestParam.getRequestContext(), "User displayable: " + user.getDisplayableId() + " ;User unique identifier(Base64UrlEncoded(uid).Base64UrlEncoded(utid)): " + MsalUtils.getUniqueUserIdentifier(user.getUid(), user.getUtid()));
            }
            return null;
        }
        if (accessTokenCacheItems.size() > 1) {
            Logger.verbose(TAG, requestParam.getRequestContext(), "Multiple access tokens are returned, cannot determine which one to return.");
            return null;
        }
        AccessTokenCacheItem accessTokenCacheItem = accessTokenCacheItems.get(0);
        if (!accessTokenCacheItem.isExpired()) {
            return accessTokenCacheItem;
        }
        Logger.info(TAG, requestParam.getRequestContext(), "Access token is found but it's expired.");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    AccessTokenCacheItem findAccessTokenItemAuthorityNotProvided(AuthenticationRequestParameters requestParameters, User user) throws MsalClientException {
        void var6_10;
        void var7_14;
        List<AccessTokenCacheItem> accessTokenCacheItems = this.getAllAccessTokensForApp(requestParameters.getClientId(), requestParameters.getRequestContext());
        ArrayList<AccessTokenCacheItem> matchingATs = new ArrayList<AccessTokenCacheItem>();
        for (AccessTokenCacheItem accessTokenCacheItem : accessTokenCacheItems) {
            if (!user.getUserIdentifier().equals(accessTokenCacheItem.getUserIdentifier())) continue;
            matchingATs.add(accessTokenCacheItem);
        }
        if (matchingATs.isEmpty()) {
            Logger.verbose(TAG, requestParameters.getRequestContext(), "No tokens matching the user exist.");
            return null;
        }
        ArrayList<AccessTokenCacheItem> accessTokenWithScopeMatching = new ArrayList<AccessTokenCacheItem>();
        for (AccessTokenCacheItem accessTokenCacheItem : matchingATs) {
            if (!accessTokenCacheItem.getScope().containsAll(requestParameters.getScope())) continue;
            accessTokenWithScopeMatching.add(accessTokenCacheItem);
        }
        if (accessTokenWithScopeMatching.size() > 1) {
            Logger.error(TAG, requestParameters.getRequestContext(), "Authority is not provided for the silent request. Multiple matching tokens were detected.", null);
            throw new MsalClientException("multiple_matching_tokens_detected", "Authority is not provided for the silent request. There are multiple matching tokens detected. ");
        }
        Object var6_8 = null;
        if (accessTokenWithScopeMatching.size() == 1) {
            AccessTokenCacheItem accessTokenCacheItem = (AccessTokenCacheItem)accessTokenWithScopeMatching.get(0);
            String string = accessTokenCacheItem.getAuthority();
        } else {
            HashSet<String> uniqueAuthorities = new HashSet<String>();
            for (AccessTokenCacheItem accessTokenCacheItem : matchingATs) {
                uniqueAuthorities.add(accessTokenCacheItem.getAuthority());
            }
            if (uniqueAuthorities.size() != 1) {
                Logger.error(TAG, requestParameters.getRequestContext(), "Authority is not provided for the silent request. Mutiple authorities found.", null);
                StringBuilder foundAuthorities = new StringBuilder();
                while (uniqueAuthorities.iterator().hasNext()) {
                    foundAuthorities.append((String)uniqueAuthorities.iterator().next());
                    foundAuthorities.append("; ");
                }
                Logger.errorPII(TAG, requestParameters.getRequestContext(), "The authorities found in the cache are: " + foundAuthorities.toString(), null);
                throw new MsalClientException("multiple_matching_tokens_detected", "Authority is not provided for the silent request. There are multiple matching tokens detected. ");
            }
            String string = (String)uniqueAuthorities.iterator().next();
        }
        Logger.verbosePII(TAG, requestParameters.getRequestContext(), "Authority is not provided but found one matching access token item, authority is: " + (String)var7_14);
        requestParameters.setAuthority((String)var7_14, requestParameters.getAuthority().mValidateAuthority);
        if (var6_10 != null && !var6_10.isExpired()) {
            return var6_10;
        }
        Logger.verbose(TAG, requestParameters.getRequestContext(), "Access token item found in the cache is already expired.");
        return null;
    }

    RefreshTokenCacheItem findRefreshToken(AuthenticationRequestParameters requestParam, User user) throws MsalClientException {
        RefreshTokenCacheKey key = RefreshTokenCacheKey.createTokenCacheKey(requestParam.getAuthority().getAuthorityHost(), requestParam.getClientId(), user);
        List<RefreshTokenCacheItem> refreshTokenCacheItems = this.getRefreshTokens(key, requestParam.getRequestContext());
        if (refreshTokenCacheItems.size() == 0) {
            Logger.info(TAG, requestParam.getRequestContext(), "No RT was found for the given user.");
            Logger.infoPII(TAG, requestParam.getRequestContext(), "The given user info is: " + user.getDisplayableId() + "; userIdentifier: " + MsalUtils.getUniqueUserIdentifier(user.getUid(), user.getUtid()));
            return null;
        }
        if (refreshTokenCacheItems.size() > 1) {
            throw new MsalClientException("multiple_matching_tokens_detected", "Multiple tokens were detected.");
        }
        return refreshTokenCacheItems.get(0);
    }

    void deleteRT(RefreshTokenCacheItem rtItem, RequestContext requestContext) {
        Logger.info(TAG, requestContext, "Removing refresh tokens from the cache.");
        if (rtItem == null) {
            Logger.warning(TAG, requestContext, "Null refresh token item is passed.");
            return;
        }
        Logger.verbosePII(TAG, requestContext, "Removing refresh token for user: " + rtItem.getDisplayableId() + "; user identifier: " + rtItem.getUserIdentifier());
        this.mTokenCacheAccessor.deleteRefreshToken(rtItem.extractTokenCacheKey().toString(), requestContext);
    }

    List<User> getUsers(String environment, String clientId, RequestContext requestContext) throws MsalClientException {
        if (MsalUtils.isEmpty(clientId)) {
            throw new IllegalArgumentException("empty or null clientId");
        }
        Logger.verbosePII(TAG, requestContext, "Retrieve users with the given client id: " + clientId);
        List<RefreshTokenCacheItem> allRefreshTokensForApp = this.getAllRefreshTokenForApp(clientId, requestContext);
        HashMap<String, User> allUsers = new HashMap<String, User>();
        for (RefreshTokenCacheItem item : allRefreshTokensForApp) {
            if (!environment.equalsIgnoreCase(item.getEnvironment())) continue;
            User user = item.getUser();
            allUsers.put(item.getUserIdentifier(), user);
        }
        return Collections.unmodifiableList(new ArrayList(allUsers.values()));
    }

    private boolean tokenMatchesUser(User user, BaseTokenCacheItem token) {
        return token.getUserIdentifier().equals(user.getUserIdentifier());
    }

    private void deleteTokenByUser(User user, List<? extends BaseTokenCacheItem> tokens, RequestContext requestContext, DeleteTokenAction delegate) {
        for (BaseTokenCacheItem baseTokenCacheItem : tokens) {
            if (!this.tokenMatchesUser(user, baseTokenCacheItem)) continue;
            Logger.verbosePII(TAG, requestContext, "Remove tokens for user with displayable " + user.getDisplayableId() + "; User identifier: " + user.getUserIdentifier());
            delegate.deleteToken(baseTokenCacheItem);
            return;
        }
    }

    void deleteRefreshTokenByUser(User user, final RequestContext requestContext) {
        this.deleteTokenByUser(user, this.getAllRefreshTokens(requestContext), requestContext, new DeleteTokenAction(){

            @Override
            public void deleteToken(BaseTokenCacheItem target) {
                RefreshTokenCacheItem refreshTokenCacheItem = (RefreshTokenCacheItem)target;
                TokenCache.this.mTokenCacheAccessor.deleteRefreshToken(refreshTokenCacheItem.extractTokenCacheKey().toString(), requestContext);
            }
        });
    }

    void deleteAccessTokenByUser(User user, final RequestContext requestContext) {
        this.deleteTokenByUser(user, this.getAllAccessTokens(requestContext), requestContext, new DeleteTokenAction(){

            @Override
            public void deleteToken(BaseTokenCacheItem target) {
                AccessTokenCacheItem accessTokenCacheItem = (AccessTokenCacheItem)target;
                TokenCache.this.mTokenCacheAccessor.deleteAccessToken(accessTokenCacheItem.extractTokenCacheKey().toString(), requestContext);
            }
        });
    }

    List<RefreshTokenCacheItem> getAllRefreshTokens(RequestContext requestContext) {
        Collection<String> refreshTokensAsString = this.mTokenCacheAccessor.getAllRefreshTokens(requestContext.getTelemetryRequestId());
        if (refreshTokensAsString == null) {
            Logger.verbose(TAG, requestContext, "No refresh tokens existed in the token cache.");
            return Collections.emptyList();
        }
        ArrayList<RefreshTokenCacheItem> refreshTokenCacheItems = new ArrayList<RefreshTokenCacheItem>(refreshTokensAsString.size());
        for (String refreshTokenAsString : refreshTokensAsString) {
            RefreshTokenCacheItem refreshTokenCacheItem = (RefreshTokenCacheItem)this.mGson.fromJson(refreshTokenAsString, RefreshTokenCacheItem.class);
            refreshTokenCacheItems.add(refreshTokenCacheItem);
        }
        return refreshTokenCacheItems;
    }

    List<AccessTokenCacheItem> getAllAccessTokens(RequestContext requestContext) {
        Collection<String> accessTokensAsString = this.mTokenCacheAccessor.getAllAccessTokens(requestContext.getTelemetryRequestId());
        if (accessTokensAsString == null) {
            Logger.verbose(TAG, requestContext, "No access tokens existed in the token cache.");
            return Collections.emptyList();
        }
        ArrayList<AccessTokenCacheItem> accessTokenCacheItems = new ArrayList<AccessTokenCacheItem>(accessTokensAsString.size());
        for (String accessTokenString : accessTokensAsString) {
            AccessTokenCacheItem accessTokenCacheItem = (AccessTokenCacheItem)this.mGson.fromJson(accessTokenString, AccessTokenCacheItem.class);
            accessTokenCacheItems.add(accessTokenCacheItem);
        }
        return accessTokenCacheItems;
    }

    private List<RefreshTokenCacheItem> getAllRefreshTokenForApp(String clientId, RequestContext requestContext) {
        List<RefreshTokenCacheItem> allRTs = this.getAllRefreshTokens(requestContext);
        ArrayList<RefreshTokenCacheItem> allRTsForApp = new ArrayList<RefreshTokenCacheItem>(allRTs.size());
        for (RefreshTokenCacheItem refreshTokenCacheItem : allRTs) {
            if (!clientId.equalsIgnoreCase(refreshTokenCacheItem.getClientId())) continue;
            allRTsForApp.add(refreshTokenCacheItem);
        }
        Logger.verbosePII(TAG, requestContext, "Retrieve all the refresh tokens for given client id: " + clientId);
        Logger.verbose(TAG, requestContext, "Returned refresh token number is " + allRTsForApp.size());
        return Collections.unmodifiableList(allRTsForApp);
    }

    private List<AccessTokenCacheItem> getAllAccessTokensForApp(String clientId, RequestContext requestContext) {
        List<AccessTokenCacheItem> allATs = this.getAllAccessTokens(requestContext);
        ArrayList<AccessTokenCacheItem> allATsForApp = new ArrayList<AccessTokenCacheItem>(allATs.size());
        for (AccessTokenCacheItem accessTokenCacheItem : allATs) {
            if (!clientId.equalsIgnoreCase(accessTokenCacheItem.getClientId())) continue;
            allATsForApp.add(accessTokenCacheItem);
        }
        return Collections.unmodifiableList(allATsForApp);
    }

    private List<RefreshTokenCacheItem> getRefreshTokens(RefreshTokenCacheKey refreshTokenCacheKey, RequestContext requestContext) {
        List<RefreshTokenCacheItem> allRTs = this.getAllRefreshTokens(requestContext);
        ArrayList<RefreshTokenCacheItem> foundRTs = new ArrayList<RefreshTokenCacheItem>();
        for (RefreshTokenCacheItem refreshTokenCacheItem : allRTs) {
            if (!refreshTokenCacheKey.matches(refreshTokenCacheItem)) continue;
            foundRTs.add(refreshTokenCacheItem);
        }
        Logger.verbose(TAG, requestContext, "Retrieve refresh tokens for the given cache key");
        Logger.verbosePII(TAG, requestContext, "Key used to retrieve refresh tokens is: " + refreshTokenCacheKey.toString());
        return foundRTs;
    }

    private List<AccessTokenCacheItem> getAccessTokens(AccessTokenCacheKey tokenCacheKey, RequestContext requestContext) {
        List<AccessTokenCacheItem> accessTokens = this.getAllAccessTokens(requestContext);
        ArrayList<AccessTokenCacheItem> foundATs = new ArrayList<AccessTokenCacheItem>();
        for (AccessTokenCacheItem accessTokenCacheItem : accessTokens) {
            if (!tokenCacheKey.matches(accessTokenCacheItem) || !accessTokenCacheItem.getScope().containsAll(tokenCacheKey.getScope())) continue;
            foundATs.add(accessTokenCacheItem);
        }
        Logger.verbose(TAG, requestContext, "Retrieve access tokens for the given cache key.");
        Logger.verbosePII(TAG, requestContext, "Key used to retrieve access tokens is: " + tokenCacheKey);
        return foundATs;
    }

    private static interface DeleteTokenAction {
        public void deleteToken(BaseTokenCacheItem var1);
    }
}

