/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.BaseOauth2Response;
import java.util.Map;

final class TenantDiscoveryResponse
extends BaseOauth2Response {
    private final String mAuthorizationEndpoint;
    private final String mTokenEndpoint;

    TenantDiscoveryResponse(String authorizationEndpoint, String tokenEndpoint) {
        super(null, null, 0);
        this.mAuthorizationEndpoint = authorizationEndpoint;
        this.mTokenEndpoint = tokenEndpoint;
    }

    TenantDiscoveryResponse(String error, String errorDescription, int httpStatusCode) {
        super(error, errorDescription, httpStatusCode);
        this.mAuthorizationEndpoint = null;
        this.mTokenEndpoint = null;
    }

    TenantDiscoveryResponse(BaseOauth2Response response) {
        this(response.getError(), response.getErrorDescription(), response.getHttpStatusCode());
    }

    String getAuthorizationEndpoint() {
        return this.mAuthorizationEndpoint;
    }

    String getTokenEndpoint() {
        return this.mTokenEndpoint;
    }

    static TenantDiscoveryResponse createSuccessTenantDiscoveryResponse(Map<String, String> responseClaims) {
        String authorizationEndpoint = responseClaims.get("authorization_endpoint");
        String tokenEndpoint = responseClaims.get("token_endpoint");
        return new TenantDiscoveryResponse(authorizationEndpoint, tokenEndpoint);
    }
}

