/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.ApiEvent;
import com.microsoft.identity.client.DefaultEvent;
import com.microsoft.identity.client.Event;
import com.microsoft.identity.client.EventDispatcher;
import com.microsoft.identity.client.IMsalEventReceiver;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.OrphanedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class Telemetry {
    private static final String TAG = Telemetry.class.getSimpleName();
    private static final Telemetry INSTANCE = new Telemetry();
    private static boolean sDisableForTest;
    private static boolean sAllowPii;
    private final Map<String, List<Event.Builder>> mEvents = Collections.synchronizedMap(new LinkedHashMap());
    private EventDispatcher mPublisher;
    private boolean mTelemetryOnFailureOnly = false;

    private Telemetry() {
    }

    static Telemetry getTestInstance() {
        return new Telemetry();
    }

    public static Telemetry getInstance() {
        return INSTANCE;
    }

    static String generateNewRequestId() {
        return UUID.randomUUID().toString();
    }

    static void disableForTest(boolean disabled) {
        sDisableForTest = disabled;
    }

    public static void setAllowPii(boolean allowFlag) {
        sAllowPii = allowFlag;
    }

    public static boolean getAllowPii() {
        return sAllowPii;
    }

    public synchronized void registerReceiver(IMsalEventReceiver receiver) {
        if (null == receiver) {
            throw new IllegalArgumentException("Receiver instance cannot be null");
        }
        if (null != this.mPublisher) {
            throw new IllegalStateException(IMsalEventReceiver.class.getSimpleName() + " instances are not swappable at this time.");
        }
        this.mPublisher = new EventDispatcher(receiver);
    }

    public void setTelemetryOnFailureOnly(boolean onFailure) {
        this.mTelemetryOnFailureOnly = onFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startEvent(String requestId, Event.Builder eventBuilder) {
        if (null == this.mPublisher || sDisableForTest) {
            return;
        }
        eventBuilder.setStartTime(System.currentTimeMillis());
        Telemetry telemetry = this;
        synchronized (telemetry) {
            if (null == this.mEvents.get(requestId)) {
                ArrayList<Event.Builder> eventBuilders = new ArrayList<Event.Builder>();
                eventBuilders.add(eventBuilder);
                this.mEvents.put(requestId, eventBuilders);
            } else {
                this.mEvents.get(requestId).add(eventBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopEvent(String requestId, Event.Builder eventBuilder) {
        List<Event.Builder> eventsForId;
        if (null == this.mPublisher || sDisableForTest) {
            return;
        }
        Telemetry telemetry = this;
        synchronized (telemetry) {
            eventsForId = this.mEvents.get(requestId);
        }
        Event.Builder builderToStop = null;
        for (Event.Builder builder : eventsForId) {
            if (!builder.getEventName().equals(eventBuilder.getEventName()) || builder.getIsCompleted()) continue;
            builderToStop = builder;
            break;
        }
        if (null == builderToStop) {
            Logger.warning(TAG, null, "Could not stop Event: [" + eventBuilder.getEventName() + "] because no Event in progress was found.");
            return;
        }
        Long eventStartTime = builderToStop.getStartTime();
        if (null == eventStartTime) {
            Logger.warning(TAG, null, "Stop Event called without a corresponding start_event");
            return;
        }
        long startTimeL = Long.parseLong(eventStartTime.toString());
        long stopTimeL = System.currentTimeMillis();
        long diffTime = stopTimeL - startTimeL;
        builderToStop.setStopTime(stopTimeL);
        builderToStop.setElapsedTime(diffTime);
        builderToStop.setIsCompleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(String requestId) {
        List<Event.Builder> eventsToBuild;
        if (null == this.mPublisher) {
            return;
        }
        Telemetry telemetry = this;
        synchronized (telemetry) {
            eventsToBuild = this.mEvents.remove(requestId);
        }
        if (null == eventsToBuild) {
            Logger.warning(TAG, null, "No completed Events returned for RequestId.");
            return;
        }
        ArrayList<Event> eventsToDispatch = new ArrayList<Event>();
        for (Event.Builder builder : eventsToBuild) {
            if (builder.getIsCompleted()) {
                eventsToDispatch.add(builder.build());
                continue;
            }
            Event orphanedEvent = new OrphanedEvent.Builder(builder.getEventName(), builder.getStartTime()).build();
            eventsToDispatch.add(orphanedEvent);
        }
        if (this.mTelemetryOnFailureOnly) {
            boolean shouldRemoveEvents = false;
            for (Event event : eventsToDispatch) {
                if (!(event instanceof ApiEvent)) continue;
                ApiEvent apiEvent = (ApiEvent)event;
                shouldRemoveEvents = apiEvent.wasSuccessful();
                break;
            }
            if (shouldRemoveEvents) {
                eventsToDispatch.clear();
            }
        }
        if (!eventsToDispatch.isEmpty()) {
            eventsToDispatch.add(0, new DefaultEvent.Builder().build());
            this.mPublisher.dispatch(eventsToDispatch);
        }
    }

    static {
        sAllowPii = false;
    }
}

