/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Context;
import com.microsoft.identity.client.AccessTokenCacheItem;
import com.microsoft.identity.client.AuthenticationRequestParameters;
import com.microsoft.identity.client.AuthenticationResult;
import com.microsoft.identity.client.BaseRequest;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalServiceException;
import com.microsoft.identity.client.MsalUiRequiredException;
import com.microsoft.identity.client.MsalUserCancelException;
import com.microsoft.identity.client.Oauth2Client;
import com.microsoft.identity.client.RefreshTokenCacheItem;
import com.microsoft.identity.client.TokenCache;
import com.microsoft.identity.client.User;

final class SilentRequest
extends BaseRequest {
    private static final String TAG = SilentRequest.class.getSimpleName();
    private RefreshTokenCacheItem mRefreshTokenCacheItem;
    private final boolean mForceRefresh;
    private final User mUser;
    private AuthenticationResult mAuthResult;
    private boolean mIsAuthorityProvided = true;

    SilentRequest(Context appContext, AuthenticationRequestParameters authRequestParams, boolean forceRefresh, User user) {
        super(appContext, authRequestParams);
        this.mForceRefresh = forceRefresh;
        this.mUser = user;
    }

    @Override
    void preTokenRequest() throws MsalClientException, MsalUiRequiredException, MsalServiceException, MsalUserCancelException {
        AccessTokenCacheItem tokenCacheItemAuthorityNotProvided;
        TokenCache tokenCache = this.mAuthRequestParameters.getTokenCache();
        AccessTokenCacheItem accessTokenCacheItem = tokenCacheItemAuthorityNotProvided = this.mIsAuthorityProvided ? null : tokenCache.findAccessTokenItemAuthorityNotProvided(this.mAuthRequestParameters, this.mUser);
        if (!this.mForceRefresh) {
            AccessTokenCacheItem accessTokenCacheItem2;
            AccessTokenCacheItem accessTokenCacheItem3 = accessTokenCacheItem2 = this.mIsAuthorityProvided ? tokenCache.findAccessToken(this.mAuthRequestParameters, this.mUser) : tokenCacheItemAuthorityNotProvided;
            if (accessTokenCacheItem2 != null) {
                Logger.info(TAG, this.mAuthRequestParameters.getRequestContext(), "Access token is found, returning cached AT.");
                this.mAuthResult = new AuthenticationResult(accessTokenCacheItem2);
                return;
            }
        } else {
            Logger.info(TAG, this.mAuthRequestParameters.getRequestContext(), "ForceRefresh is set to true, skipping AT lookup.");
        }
        this.mRefreshTokenCacheItem = tokenCache.findRefreshToken(this.mAuthRequestParameters, this.mUser);
        if (this.mRefreshTokenCacheItem == null) {
            Logger.info(TAG, this.mAuthRequestParameters.getRequestContext(), "No refresh token item is found.");
            throw new MsalUiRequiredException("no_tokens_found", "No refresh token was found. ");
        }
        super.preTokenRequest();
    }

    @Override
    void setAdditionalOauthParameters(Oauth2Client oauth2Client) {
        oauth2Client.addBodyParameter("grant_type", "refresh_token");
        oauth2Client.addBodyParameter("refresh_token", this.mRefreshTokenCacheItem.getRefreshToken());
    }

    @Override
    void performTokenRequest() throws MsalServiceException, MsalClientException {
        if (this.mAuthResult != null) {
            return;
        }
        super.performTokenRequest();
    }

    @Override
    AuthenticationResult postTokenRequest() throws MsalServiceException, MsalUiRequiredException, MsalClientException {
        if (this.mAuthResult != null) {
            return this.mAuthResult;
        }
        if (!this.isAccessTokenReturned()) {
            this.throwExceptionFromTokenResponse(this.mTokenResponse);
        }
        return super.postTokenRequest();
    }

    void setIsAuthorityProvided(boolean isAuthorityProvided) {
        this.mIsAuthorityProvided = isAuthorityProvided;
    }
}

