/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.BaseTokenCacheItem;
import com.microsoft.identity.client.IdToken;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.RefreshTokenCacheKey;
import com.microsoft.identity.client.TokenResponse;
import com.microsoft.identity.client.User;

final class RefreshTokenCacheItem
extends BaseTokenCacheItem {
    @SerializedName(value="refresh_token")
    private String mRefreshToken;
    @SerializedName(value="environment")
    private String mEnvironment;
    @SerializedName(value="displayable_id")
    String mDisplayableId;
    @SerializedName(value="name")
    String mName;
    @SerializedName(value="identity_provider")
    String mIdentityProvider;

    RefreshTokenCacheItem() {
    }

    RefreshTokenCacheItem(String environment, String clientId, TokenResponse response) throws MsalClientException {
        super(clientId, response.getRawClientInfo());
        this.mEnvironment = environment;
        this.mRefreshToken = response.getRefreshToken();
        IdToken idToken = new IdToken(response.getRawIdToken());
        this.mDisplayableId = idToken.getPreferredName();
        this.mName = idToken.getName();
        this.mIdentityProvider = idToken.getIssuer();
        this.mUser = new User(this.mDisplayableId, this.mName, this.mIdentityProvider, this.getClientInfo().getUniqueIdentifier(), this.getClientInfo().getUniqueTenantIdentifier());
    }

    @Override
    RefreshTokenCacheKey extractTokenCacheKey() {
        return RefreshTokenCacheKey.createTokenCacheKey(this.mEnvironment, this.mClientId, this.mUser);
    }

    String getRefreshToken() {
        return this.mRefreshToken;
    }

    String getEnvironment() {
        return this.mEnvironment;
    }

    String getDisplayableId() {
        return this.mDisplayableId;
    }

    String getName() {
        return this.mName;
    }

    String getIdentityProvider() {
        return this.mIdentityProvider;
    }
}

