/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.os.Build;
import com.microsoft.identity.client.PublicClientApplication;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class PlatformIdHelper {
    private PlatformIdHelper() {
    }

    static Map<String, String> getPlatformIdParameters() {
        HashMap<String, String> platformParameters = new HashMap<String, String>();
        platformParameters.put("x-client-SKU", "MSAL.Android");
        platformParameters.put("x-client-Ver", PublicClientApplication.getSdkVersion());
        if (Build.VERSION.SDK_INT < 21) {
            platformParameters.put("x-client-CPU", Build.CPU_ABI);
        } else {
            String[] supportedABIs = Build.SUPPORTED_ABIS;
            if (supportedABIs != null && supportedABIs.length > 0) {
                platformParameters.put("x-client-CPU", supportedABIs[0]);
            }
        }
        platformParameters.put("x-client-OS", String.valueOf(Build.VERSION.SDK_INT));
        platformParameters.put("x-client-DM", Build.MODEL);
        return Collections.unmodifiableMap(platformParameters);
    }

    static final class PlatformIdParameters {
        static final String PRODUCT = "x-client-SKU";
        static final String PRODUCT_NAME = "MSAL.Android";
        static final String VERSION = "x-client-Ver";
        static final String CPU_PLATFORM = "x-client-CPU";
        static final String OS = "x-client-OS";
        static final String DEVICE_MODEL = "x-client-DM";

        PlatformIdParameters() {
        }
    }
}

