/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

final class OauthConstants {
    OauthConstants() {
    }

    static final class ClientInfoClaim {
        static final String UNIQUE_IDENTIFIER = "uid";
        static final String UNIQUE_TENANT_IDENTIFIER = "utid";

        ClientInfoClaim() {
        }
    }

    static final class TenantDiscoveryClaim {
        static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
        static final String TOKEN_ENDPOINT = "token_endpoint";

        TenantDiscoveryClaim() {
        }
    }

    static final class InstanceDiscoveryClaim {
        static final String TENANT_DISCOVERY_ENDPOINT = "tenant_discovery_endpoint";

        InstanceDiscoveryClaim() {
        }
    }

    static final class ErrorCode {
        static final String INVALID_GRANT = "invalid_grant";

        ErrorCode() {
        }
    }

    static final class TokenResponseClaim {
        static final String CODE = "code";
        static final String TOKEN_TYPE = "token_type";
        static final String ACCESS_TOKEN = "access_token";
        static final String REFRESH_TOKEN = "refresh_token";
        static final String SCOPE = "scope";
        static final String ID_TOKEN = "id_token";
        static final String EXPIRES_IN = "expires_in";
        static final String ID_TOKEN_EXPIRES_IN = "id_token_expires_in";
        static final String EXTENDED_EXPIRES_IN = "ext_expires_in";
        static final String STATE = "state";
        static final String CLIENT_INFO = "client_info";

        TokenResponseClaim() {
        }
    }

    static final class BaseOauth2ResponseClaim {
        static final String ERROR = "error";
        static final String ERROR_DESCRIPTION = "error_description";
        static final String ERROR_CODES = "error_codes";
        static final String CORRELATION_ID = "correlation_id";
        static final String CLAIMS = "claims";

        BaseOauth2ResponseClaim() {
        }
    }

    static final class Authorize {
        static final String ERROR = "error";
        static final String ERROR_DESCRIPTION = "error_description";
        static final String ERROR_SUBCODE = "error_subcode";
        static final String CANCEL = "cancel";

        Authorize() {
        }
    }

    static final class OauthHeader {
        static final String CORRELATION_ID = "client-request-id";
        static final String CORRELATION_ID_IN_RESPONSE = "return-client-request-id";

        OauthHeader() {
        }
    }

    static final class PromptValue {
        static final String LOGIN = "login";
        static final String SELECT_ACCOUNT = "select_account";
        static final String CONSENT = "consent";

        PromptValue() {
        }
    }

    static final class Oauth2Value {
        static final String SCOPE_PROFILE = "profile";
        static final String[] RESERVED_SCOPES = new String[]{"openid", "profile", "offline_access"};

        Oauth2Value() {
        }
    }

    static final class Oauth2GrantType {
        static final String AUTHORIZATION_CODE = "authorization_code";
        static final String REFRESH_TOKEN = "refresh_token";

        Oauth2GrantType() {
        }
    }

    static final class Oauth2ResponseType {
        static final String CODE = "code";

        Oauth2ResponseType() {
        }
    }

    static final class Oauth2Parameters {
        static final String RESPONSE_TYPE = "response_type";
        static final String GRANT_TYPE = "grant_type";
        static final String CLIENT_ID = "client_id";
        static final String REFRESH_TOKEN = "refresh_token";
        static final String REDIRECT_URI = "redirect_uri";
        static final String CODE = "code";
        static final String SCOPE = "scope";
        static final String LOGIN_HINT = "login_hint";
        static final String PROMPT = "prompt";
        static final String HAS_CHROME = "haschrome";
        static final String STATE = "state";
        static final String CODE_CHALLENGE = "code_challenge";
        static final String CODE_VERIFIER = "code_verifier";
        static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
        static final String CLIENT_INFO = "client_info";
        static final String LOGIN_REQ = "login_req";
        static final String DOMAIN_REQ = "domain_req";

        Oauth2Parameters() {
        }
    }
}

