/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.AadAuthority;
import com.microsoft.identity.client.Event;
import com.microsoft.identity.client.MsalUtils;
import java.net.URL;
import java.util.Arrays;

final class HttpEvent
extends Event {
    private HttpEvent(Builder builder) {
        super(builder);
        this.setProperty("msal.user_agent", builder.mUserAgent);
        this.setProperty("msal.method", builder.mHttpMethod);
        this.setProperty("msal.query_params", builder.mQueryParams);
        this.setProperty("msal.api_version", builder.mApiVersion);
        this.setProperty("msal.oauth_error_code", builder.mOAuthErrorCode);
        this.setProperty("msal.x_ms_request_id", builder.mRequestIdHeader);
        if (null != builder.mHttpPath) {
            this.setHttpPath(builder.mHttpPath);
        }
        this.setProperty("msal.response_code", String.valueOf(builder.mResponseCode));
    }

    static String sanitizeUrlForTelemetry(String url) {
        URL urlToSanitize = MsalUtils.getUrl(url);
        return urlToSanitize == null ? null : HttpEvent.sanitizeUrlForTelemetry(urlToSanitize);
    }

    static String sanitizeUrlForTelemetry(URL url) {
        String authority = url.getAuthority();
        String[] pathSegments = url.getPath().replaceFirst("/", "").split("/");
        boolean isB2cAuthority = pathSegments[0].equals("tfp");
        if (!Arrays.asList(AadAuthority.TRUSTED_HOSTS).contains(authority) || isB2cAuthority) {
            return null;
        }
        String[] splitArray = url.getPath().split("/");
        StringBuilder logPath = new StringBuilder();
        logPath.append(url.getProtocol());
        logPath.append("://");
        logPath.append(authority);
        logPath.append("/");
        for (int i = 2; i < splitArray.length; ++i) {
            logPath.append(splitArray[i]);
            logPath.append("/");
        }
        return logPath.toString();
    }

    private void setHttpPath(URL httpPath) {
        this.setProperty("msal.http_path", HttpEvent.sanitizeUrlForTelemetry(httpPath));
    }

    String getUserAgent() {
        return this.getProperty("msal.user_agent");
    }

    String getHttpMethod() {
        return this.getProperty("msal.method");
    }

    String getQueryParameters() {
        return this.getProperty("msal.query_params");
    }

    String getApiVersion() {
        return this.getProperty("msal.api_version");
    }

    String getOAuthErrorCode() {
        return this.getProperty("msal.oauth_error_code");
    }

    String getRequestIdHeader() {
        return this.getProperty("msal.x_ms_request_id");
    }

    URL getHttpPath() {
        return MsalUtils.getUrl(this.getProperty("msal.http_path"));
    }

    Integer getResponseCode() {
        return Integer.valueOf(this.getProperty("msal.response_code"));
    }

    static class Builder
    extends Event.Builder<Builder> {
        private String mUserAgent;
        private String mHttpMethod;
        private String mQueryParams;
        private String mApiVersion;
        private String mOAuthErrorCode;
        private String mRequestIdHeader;
        private URL mHttpPath;
        private Integer mResponseCode;

        Builder() {
            super("msal.http_event");
        }

        Builder setUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        Builder setHttpMethod(String httpMethod) {
            this.mHttpMethod = httpMethod;
            return this;
        }

        Builder setQueryParameters(String queryParams) {
            this.mQueryParams = queryParams;
            return this;
        }

        Builder setApiVersion(String apiVersion) {
            this.mApiVersion = apiVersion;
            return this;
        }

        Builder setOAuthErrorCode(String oAuthErrorCode) {
            this.mOAuthErrorCode = oAuthErrorCode;
            return this;
        }

        Builder setRequestIdHeader(String requestIdHeader) {
            this.mRequestIdHeader = requestIdHeader;
            return this;
        }

        Builder setHttpPath(URL httpPath) {
            this.mHttpPath = httpPath;
            return this;
        }

        Builder setStatusCode(Integer responseCode) {
            this.mResponseCode = responseCode;
            return this;
        }

        @Override
        HttpEvent build() {
            return new HttpEvent(this);
        }
    }
}

