/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.util.Pair;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.Telemetry;
import com.microsoft.identity.client.TelemetryUtils;
import java.util.ArrayList;

class Event
extends ArrayList<Pair<String, String>> {
    Event(Builder builder) {
        if (null == builder.mEventName) {
            throw new IllegalStateException("Event must have a name");
        }
        if (!"msal.default".equals(builder.mEventName)) {
            this.setProperty("msal.event_name", builder.mEventName);
        }
        if (null != builder.mEventStartTime) {
            this.setProperty("msal.start_time", String.valueOf(builder.mEventStartTime));
        }
        if (null != builder.mEventStartTime) {
            this.setProperty("msal.stop_time", String.valueOf(builder.mEventStopTime));
        }
        if (null != builder.mEventElapsedTime) {
            this.setProperty("msal.elapsed_time", String.valueOf(builder.mEventElapsedTime));
        }
    }

    final void setProperty(String propertyName, String propertyValue) {
        if (!MsalUtils.isEmpty(propertyName) && !MsalUtils.isEmpty(propertyValue) && Event.isPrivacyCompliant(propertyName)) {
            this.add(new Pair((Object)propertyName, (Object)propertyValue));
        }
    }

    final String getProperty(String propertyName) {
        String propertyValue = null;
        for (Pair property : this) {
            if (!((String)property.first).equals(propertyName)) continue;
            propertyValue = (String)property.second;
            break;
        }
        return propertyValue;
    }

    int getPropertyCount() {
        return this.size();
    }

    String getEventName() {
        return this.getProperty("msal.event_name");
    }

    Long getStartTime() {
        return Long.valueOf(this.getProperty("msal.start_time"));
    }

    Long getStopTime() {
        return Long.valueOf(this.getProperty("msal.stop_time"));
    }

    Long getElapsedTime() {
        return Long.valueOf(this.getProperty("msal.elapsed_time"));
    }

    static boolean isPrivacyCompliant(String fieldName) {
        return Telemetry.getAllowPii() || !TelemetryUtils.GDPR_FILTERED_FIELDS.contains(fieldName);
    }

    static abstract class Builder<T extends Builder> {
        private final String mEventName;
        private Long mEventStartTime;
        private Long mEventStopTime;
        private Long mEventElapsedTime;
        private boolean mIsCompleted;

        Builder(String name) {
            this.mEventName = name;
        }

        final String getEventName() {
            return this.mEventName;
        }

        final Long getStartTime() {
            return this.mEventStartTime;
        }

        final boolean getIsCompleted() {
            return this.mIsCompleted;
        }

        final T setStartTime(long startTime) {
            this.mEventStartTime = startTime;
            return (T)this;
        }

        final T setStopTime(long stopTime) {
            this.mEventStopTime = stopTime;
            return (T)this;
        }

        final T setElapsedTime(long elapsedTime) {
            this.mEventElapsedTime = elapsedTime;
            return (T)this;
        }

        final T setIsCompleted(boolean isCompleted) {
            this.mIsCompleted = isCompleted;
            return (T)this;
        }

        abstract Event build();
    }
}

