/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.util.Base64;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalUtils;
import java.nio.charset.Charset;
import java.util.Map;
import org.json.JSONException;

final class ClientInfo {
    private final String mUniqueIdentifier;
    private final String mUniqueTenantIdentifier;

    ClientInfo(String rawClientInfo) throws MsalClientException {
        Map<String, String> clientInfoItems;
        if (MsalUtils.isEmpty(rawClientInfo)) {
            this.mUniqueIdentifier = "";
            this.mUniqueTenantIdentifier = "";
            return;
        }
        String decodedClientInfo = new String(Base64.decode((String)rawClientInfo, (int)8), Charset.forName("UTF_8"));
        try {
            clientInfoItems = MsalUtils.extractJsonObjectIntoMap(decodedClientInfo);
        }
        catch (JSONException e) {
            throw new MsalClientException("json_parse_failure", "Failed to parse the returned raw client info.");
        }
        this.mUniqueIdentifier = clientInfoItems.get("uid");
        this.mUniqueTenantIdentifier = clientInfoItems.get("utid");
    }

    String getUniqueIdentifier() {
        return MsalUtils.isEmpty(this.mUniqueIdentifier) ? "" : this.mUniqueIdentifier;
    }

    String getUniqueTenantIdentifier() {
        return MsalUtils.isEmpty(this.mUniqueTenantIdentifier) ? "" : this.mUniqueTenantIdentifier;
    }
}

