/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.Event;

final class CacheEvent
extends Event {
    private CacheEvent(Builder builder) {
        super(builder);
        this.setProperty("msal.token_type", builder.mTokenType);
        this.setProperty("msal.is_at", String.valueOf(builder.mIsAT));
        this.setProperty("msal.is_rt", String.valueOf(builder.mIsRT));
    }

    String getTokenType() {
        return this.getProperty("msal.token_type");
    }

    boolean isRT() {
        return Boolean.valueOf(this.getProperty("msal.is_rt"));
    }

    boolean isAT() {
        return Boolean.valueOf(this.getProperty("msal.is_at"));
    }

    static class Builder
    extends Event.Builder<Builder> {
        private String mTokenType;
        private boolean mIsAT;
        private boolean mIsRT;

        Builder(String eventName) {
            super(eventName);
        }

        Builder setTokenType(String tokenType) {
            this.mTokenType = tokenType;
            return this;
        }

        Builder setIsAT(boolean isAT) {
            this.mIsAT = isAT;
            return this;
        }

        Builder setIsRT(boolean isRT) {
            this.mIsRT = isRT;
            return this;
        }

        @Override
        CacheEvent build() {
            return new CacheEvent(this);
        }
    }
}

