/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.ClientInfo;
import com.microsoft.identity.client.MsalClientException;
import com.microsoft.identity.client.MsalUtils;
import com.microsoft.identity.client.TokenCacheKey;
import com.microsoft.identity.client.User;

abstract class BaseTokenCacheItem {
    @SerializedName(value="client_id")
    String mClientId;
    @SerializedName(value="client_info")
    String mRawClientInfo;
    @SerializedName(value="ver")
    private String mVersion = "1";
    transient User mUser;
    transient ClientInfo mClientInfo;

    abstract TokenCacheKey extractTokenCacheKey();

    BaseTokenCacheItem() {
    }

    BaseTokenCacheItem(String clientId, String rawClientInfo) throws MsalClientException {
        this.mClientId = clientId;
        this.mRawClientInfo = rawClientInfo;
        this.mClientInfo = new ClientInfo(rawClientInfo);
    }

    String getClientId() {
        return this.mClientId;
    }

    String getRawClientInfo() {
        return this.mRawClientInfo;
    }

    ClientInfo getClientInfo() {
        return this.mClientInfo;
    }

    void setClientInfo(ClientInfo clientInfo) {
        this.mClientInfo = clientInfo;
    }

    User getUser() {
        return this.mUser;
    }

    void setUser(User user) {
        this.mUser = user;
    }

    String getVersion() {
        return this.mVersion;
    }

    final String getUserIdentifier() {
        return MsalUtils.getUniqueUserIdentifier(this.mClientInfo.getUniqueIdentifier(), this.mClientInfo.getUniqueTenantIdentifier());
    }
}

